<?php

class SynergiaSelectWoocommerceDropdownCart extends SynergiaSelectWidget
{
    public function __construct() {
        parent::__construct(
            'qodef_woocommerce_dropdown_cart',
            esc_html__('Select Woocommerce Dropdown Cart', 'synergia'),
            array('description' => esc_html__('Display a shop cart icon with a dropdown that shows products that are in the cart', 'synergia'),)
        );

        $this->setParams();
    }

    protected function setParams() {

        $this->params = array(
            array(
                'type'        => 'textfield',
                'name'        => 'woocommerce_dropdown_cart_margin',
                'title'       => esc_html__('Icon Margin', 'synergia'),
                'description' => esc_html__('Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'synergia')
            )
        );
    }

    public function widget($args, $instance) {
        extract($args);

        global $woocommerce;

        $icon_styles = array();

        if ($instance['woocommerce_dropdown_cart_margin'] !== '') {
            $icon_styles[] = 'padding: ' . $instance['woocommerce_dropdown_cart_margin'];
        }

        $cart_is_empty = sizeof($woocommerce->cart->get_cart()) <= 0;
        ?>
        <div class="qodef-shopping-cart-holder" <?php synergia_select_inline_style($icon_styles) ?>>
            <div class="qodef-shopping-cart-inner">
                <a itemprop="url" class="qodef-header-cart"
                   href="<?php echo esc_url(wc_get_cart_url()); ?>">
                    <span class="icon_bag_alt">
                        <span
                            class="qodef-cart-icon qodef-cart-number"><?php echo sprintf(_n('%d', '%d', WC()->cart->cart_contents_count, 'synergia'), WC()->cart->cart_contents_count); ?></span>
                    </span>
                </a>

                <div class="qodef-shopping-cart-dropdown">
                    <ul>
                        <?php if (!$cart_is_empty) : ?>
                            <?php foreach ($woocommerce->cart->get_cart() as $cart_item_key => $cart_item) :
                                $_product = $cart_item['data'];
                                // Only display if allowed
                                if (!$_product->exists() || $cart_item['quantity'] == 0) {
                                    continue;
                                }
                                // Get price
                                $product_price = get_option('woocommerce_tax_display_cart') == 'excl' ? wc_get_price_excluding_tax($_product) : wc_get_price_including_tax($_product);
                                ?>
                                <li>
                                    <div class="qodef-item-image-holder">
                                        <a itemprop="url"
                                           href="<?php echo esc_url(get_permalink($cart_item['product_id'])); ?>">
                                            <?php echo wp_kses($_product->get_image(), array(
                                                'img' => array(
                                                    'src'    => true,
                                                    'width'  => true,
                                                    'height' => true,
                                                    'class'  => true,
                                                    'alt'    => true,
                                                    'title'  => true,
                                                    'id'     => true
                                                )
                                            )); ?>
                                        </a>
                                    </div>
                                    <div class="qodef-item-info-holder">
                                        <h5 itemprop="name" class="qodef-product-title">
                                            <a itemprop="url"
                                               href="<?php echo esc_url(get_permalink($cart_item['product_id'])); ?>"><?php echo apply_filters('synergia_select_woo_widget_cart_product_title', $_product->get_name(), $_product); ?></a>
                                        </h5>

                                        <div class="qodef-quantity-amount">
                                            <span
                                                class="qodef-quantity"><?php echo esc_html($cart_item['quantity']); ?></span>
                                            <span class="qodef-quantity-multiple">x</span>
                                            <?php echo apply_filters('synergia_select_woo_cart_item_price_html', wc_price($product_price), $cart_item, $cart_item_key); ?>
                                            <?php echo apply_filters('synergia_select_woo_cart_item_remove_link', sprintf('<a href="%s" class="remove" title="%s"><span class="icon-arrows-remove"></span></a>', esc_url($woocommerce->cart->get_remove_url($cart_item_key)), esc_html__('Remove this item', 'synergia')), $cart_item_key); ?>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                            <li class="qodef-cart-bottom">
                                <div class="qodef-subtotal-holder clearfix">
                                    <h6 class="qodef-total"><?php esc_html_e('Total:', 'synergia'); ?></h6>
                                    <h6 class="qodef-total-amount">
										<?php echo wp_kses($woocommerce->cart->get_cart_subtotal(), array(
                                            'span' => array(
                                                'class' => true,
                                                'id'    => true
                                            )
                                        )); ?>
									</h6>
                                </div>
                                <div class="qodef-btn-holder clearfix">
                                    <a itemprop="url"
                                       href="<?php echo esc_url(wc_get_checkout_url()); ?>"
                                       class="qodef-checkout"
                                       data-title="<?php esc_html_e('Checkout', 'synergia'); ?>">
                                        <?php esc_html_e('Checkout', 'synergia'); ?>
                                    </a>
                                    <a itemprop="url" href="<?php echo esc_url(wc_get_checkout_url()); ?>"
                                       class="qodef-view-cart"
                                       data-title="<?php esc_html_e('Shopping bag', 'synergia'); ?>">
                                        <?php esc_html_e('Shopping bag', 'synergia'); ?>
                                    </a>
                                </div>
                            </li>
                        <?php else : ?>
                            <li class="qodef-empty-cart"><?php esc_html_e('No products in the cart.', 'synergia'); ?></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php
    }
}

add_action('widgets_init', create_function('', 'register_widget( "SynergiaSelectWoocommerceDropdownCart" );'));

add_filter('woocommerce_add_to_cart_fragments', 'synergia_select_woocommerce_header_add_to_cart_fragment');

function synergia_select_woocommerce_header_add_to_cart_fragment($fragments) {
    global $woocommerce;

    ob_start();

    $cart_is_empty = sizeof($woocommerce->cart->get_cart()) <= 0;
    ?>
    <div class="qodef-shopping-cart-inner">
        <a itemprop="url" class="qodef-header-cart" href="<?php echo esc_url(wc_get_cart_url()); ?>">
            <span class="qodef-cart-icon icon_bag_alt">
                <span
                    class="qodef-cart-number"><?php echo sprintf(_n('%d', '%d', WC()->cart->cart_contents_count, 'synergia'), WC()->cart->cart_contents_count); ?></span>
            </span>
        </a>

        <div class="qodef-shopping-cart-dropdown">
            <ul>
                <?php if (!$cart_is_empty) : ?>
                    <?php foreach ($woocommerce->cart->get_cart() as $cart_item_key => $cart_item) :
                        $_product = $cart_item['data'];
                        // Only display if allowed
                        if (!$_product->exists() || $cart_item['quantity'] == 0) {
                            continue;
                        }
                        // Get price
                        $product_price = get_option('woocommerce_tax_display_cart') == 'excl' ? wc_get_price_excluding_tax($_product) : wc_get_price_including_tax($_product);
                        ?>
                        <li>
                            <div class="qodef-item-image-holder">
                                <a itemprop="url"
                                   href="<?php echo esc_url(get_permalink($cart_item['product_id'])); ?>">
                                    <?php echo wp_kses($_product->get_image(), array(
                                        'img' => array(
                                            'src'    => true,
                                            'width'  => true,
                                            'height' => true,
                                            'class'  => true,
                                            'alt'    => true,
                                            'title'  => true,
                                            'id'     => true
                                        )
                                    )); ?>
                                </a>
                            </div>
                            <div class="qodef-item-info-holder">
                                <h5 itemprop="name" class="qodef-product-title">
                                    <a itemprop="url"
                                       href="<?php echo esc_url(get_permalink($cart_item['product_id'])); ?>"><?php echo apply_filters('synergia_select_woo_widget_cart_product_title', $_product->get_name(), $_product); ?></a>
                                </h5>

                                <div class="qodef-quantity-amount">
                                    <span class="qodef-quantity"><?php echo esc_html($cart_item['quantity']); ?></span>
                                    <span class="qodef-quantity-multiple">x</span>
                                    <?php echo apply_filters('synergia_select_woo_cart_item_price_html', wc_price($product_price), $cart_item, $cart_item_key); ?>
                                    <?php echo apply_filters('synergia_select_woo_cart_item_remove_link', sprintf('<a href="%s" class="remove" title="%s"><span class="icon-arrows-remove"></span></a>', esc_url($woocommerce->cart->get_remove_url($cart_item_key)), esc_html__('Remove this item', 'synergia')), $cart_item_key); ?>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; ?>
                    <li class="qodef-cart-bottom">
                        <div class="qodef-subtotal-holder clearfix">
                            <h6 class="qodef-total"><?php esc_html_e('Total:', 'synergia'); ?></h6>
                            <h6 class="qodef-total-amount">
								<?php echo wp_kses($woocommerce->cart->get_cart_subtotal(), array(
                                    'span' => array(
                                        'class' => true,
                                        'id'    => true
                                    )
                                )); ?>
							</h6>
                        </div>
                        <div class="qodef-btn-holder clearfix">
                            <a itemprop="url"
                               href="<?php echo esc_url(wc_get_checkout_url()); ?>"
                               class="qodef-checkout"
                               data-title="<?php esc_html_e('Checkout', 'synergia'); ?>">
                                <?php esc_html_e('Checkout', 'synergia'); ?>
                            </a>
                            <a itemprop="url" href="<?php echo esc_url(wc_get_checkout_url()); ?>"
                               class="qodef-view-cart"
                               data-title="<?php esc_html_e('Shopping bag', 'synergia'); ?>">
                                <?php esc_html_e('Shopping bag', 'synergia'); ?>
                            </a>
                        </div>
                    </li>
                <?php else : ?>
                    <li class="qodef-empty-cart"><?php esc_html_e('No products in the cart.', 'synergia'); ?></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <?php
    $fragments['div.qodef-shopping-cart-inner'] = ob_get_clean();

    return $fragments;
}

?>