<?php
namespace QodeCore\CPT\Shortcodes\Product;

use QodeCore\Lib;

class Product implements Lib\ShortcodeInterface
{
    private $base;

    function __construct() {
        $this->base = 'qodef_product';

        add_action('vc_before_init', array($this, 'vcMap'));

        //Product id filter
        add_filter('vc_autocomplete_qodef_product_product_id_callback', array(&$this, 'productIdAutocompleteSuggester',), 10, 1);

        //Product id render
        add_filter('vc_autocomplete_qodef_product_product_id_render', array(&$this, 'productIdAutocompleteRender',), 10, 1);
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if (function_exists('vc_map')) {
            vc_map(
                array(
                    'name'                      => esc_html__('Select Product', 'synergia'),
                    'base'                      => $this->getBase(),
                    'category'                  => esc_html__('by Select', 'synergia'),
                    'icon'                      => 'icon-wpb-product extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
                    'params'                    => array(
                        array(
                            'type'        => 'autocomplete',
                            'param_name'  => 'product_id',
                            'heading'     => esc_html__('Selected Product', 'synergia'),
                            'settings'    => array(
                                'sortable'      => true,
                                'unique_values' => true
                            ),
                            'admin_label' => true,
                            'save_always' => true,
                            'description' => esc_html__('If you left this field empty then product ID will be of the current page', 'synergia')
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'button_text',
                            'heading'     => esc_html__('Button Text', 'synergia'),
                            'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS', 'synergia')
                        ),
                    )
                )
            );
        }
    }

    public function render($atts, $content = null) {
        $args = array(
            'product_id'  => '',
            'button_text' => ''
        );
        $params = shortcode_atts($args, $atts);

        $params['product_id'] = !empty($params['product_id']) ? $params['product_id'] : get_the_ID();
        $params['product'] = wc_get_product($params['product_id']);
        $params['button_classes'] = $this->getButtonClasses($params);

        $params['excerpt'] = get_the_excerpt($params['product_id']);
        $params['categories'] = wp_get_post_terms($params['product_id'], 'product_cat');
        $params['button_text'] = !empty($params['button_text']) ? $params['button_text'] : $params['product']->add_to_cart_text();

        $html = synergia_select_get_woo_shortcode_module_template_part('templates/product', 'product', '', $params);

        return $html;
    }

    public function getButtonClasses($params) {
        $product = wc_get_product($params['product_id']);

        if (!$product->is_in_stock()) {
            $button_classes = 'button ajax_add_to_cart qodef-btn qodef-btn-solid';
        } else if ($product->get_type() === 'variable') {
            $button_classes = 'button product_type_variable add_to_cart_button qodef-btn qodef-btn-solid';
        } else if ($product->get_type() === 'external') {
            $button_classes = 'button product_type_external qodef-btn qodef-btn-solid';
        } else {
            $button_classes = 'button add_to_cart_button ajax_add_to_cart qodef-btn qodef-btn-solid';
        }

        return $button_classes;
    }

    /**
     * Generates product rating html based on id
     *
     * @param $params
     *
     * @return html
     */
//    public function getItemRatingHtml($params) {
//        $html = '';
//        $product_id = $params['product_id'];
//        $product = wc_get_product($product_id);
//
//        if (get_option('woocommerce_enable_review_rating') !== 'no') {
//            $average = $product->get_average_rating();
//
//            $html = '<div class="qodef-pi-rating" title="' . sprintf(esc_html__("Rated %s out of 5", "synergia"), $average) . '"><span style="width:' . (($average / 5) * 100) . '%"></span></div>';
//        }
//
//        return $html;
//    }

    /**
     * Filter product by ID or Title
     *
     * @param $query
     *
     * @return array
     */
    public function productIdAutocompleteSuggester($query) {
        global $wpdb;
        $product_id = (int)$query;
        $post_meta_infos = $wpdb->get_results($wpdb->prepare("SELECT ID AS id, post_title AS title
					FROM {$wpdb->posts} 
					WHERE post_type = 'product' AND ( ID = '%d' OR post_title LIKE '%%%s%%' )", $product_id > 0 ? $product_id : -1, stripslashes($query), stripslashes($query)), ARRAY_A);

        $results = array();
        if (is_array($post_meta_infos) && !empty($post_meta_infos)) {
            foreach ($post_meta_infos as $value) {
                $data = array();
                $data['value'] = $value['id'];
                $data['label'] = esc_html__('Id', 'synergia') . ': ' . $value['id'] . ((strlen($value['title']) > 0) ? ' - ' . esc_html__('Title', 'synergia') . ': ' . $value['title'] : '');
                $results[] = $data;
            }
        }

        return $results;

    }

    /**
     * Find product by id
     * @since 4.4
     *
     * @param $query
     *
     * @return bool|array
     */
    public function productIdAutocompleteRender($query) {
        $query = trim($query['value']); // get value from requested
        if (!empty($query)) {

            $product = get_post((int)$query);
            if (!is_wp_error($product)) {

                $product_id = $product->ID;
                $product_title = $product->post_title;

                $product_title_display = '';
                if (!empty($product_title)) {
                    $product_title_display = ' - ' . esc_html__('Title', 'synergia') . ': ' . $product_title;
                }

                $product_id_display = esc_html__('Id', 'synergia') . ': ' . $product_id;

                $data = array();
                $data['value'] = $product_id;
                $data['label'] = $product_id_display . $product_title_display;

                return !empty($data) ? $data : false;
            }

            return false;
        }

        return false;
    }
}