<?php

class SynergiaSelectAuthorInfoWidget extends SynergiaSelectWidget
{
    public function __construct() {
        parent::__construct(
            'qodef_author_info_widget',
            esc_html__('Select Author Info Widget', 'synergia'),
            array('description' => esc_html__('Add author info element to widget areas', 'synergia'))
        );

        $this->setParams();
    }

    protected function setParams() {
        $this->params = array(

            array(
                'type'  => 'textfield',
                'name'  => 'extra_class',
                'title' => esc_html__('Custom CSS Class', 'synergia')
            ),
            array(
                'type'  => 'textfield',
                'name'  => 'author_username',
                'title' => esc_html__('Author Username', 'synergia')
            )

        );
    }

    public function widget($args, $instance) {

        $extra_class = '';
        if (!empty($instance['extra_class'])) {
            $extra_class = $instance['extra_class'];
        }

        $authorID = 1;
        if (!empty($instance['author_username'])) {
            $author = get_user_by('login', $instance['author_username']);

            if ($author)
                $authorID = $author->ID;
        }

        $author_name = get_the_author_meta('display_name', $authorID);

        $author_info = get_the_author_meta('description', $authorID);

        ?>


        <div class="widget qodef-author-info-widget <?php echo esc_html($extra_class); ?>">
            <div class="qodef-aiw-inner">
                <a itemprop="url" class="qodef-aiw-image" href="<?php echo esc_url(get_author_posts_url($authorID)); ?>"
                   target="_self">
                    <?php echo synergia_select_kses_img(get_avatar($authorID, 189)); ?>
                </a>

                <h4 class="qodef-aiw-title">
                    <span><?php print $author_name; ?></span>
                </h4>

                <?php if ($author_info !== "") { ?>
                    <p itemprop="description" class="qodef-aiw-text"><?php echo esc_attr(preg_replace('#<p>|<\/p>$#', '', $author_info)) ?></p>

                <?php } ?>
            </div>
        </div>


    <?php
    }
}