<?php

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme( true );
}

/**
 * Change path for overridden templates
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$dir = SELECT_ROOT_DIR . '/vc-templates';
	vc_set_shortcodes_templates_dir( $dir );
}

if ( ! function_exists( 'synergia_select_configure_visual_composer_frontend_editor' ) ) {
	/**
	 * Configuration for Visual Composer FrontEnd Editor
	 * Hooks on vc_after_init action
	 */
	function synergia_select_configure_visual_composer_frontend_editor() {
		/**
		 * Remove frontend editor
		 */
		
	}
	
	add_action( 'vc_after_init', 'synergia_select_configure_visual_composer_frontend_editor' );
}

if ( ! function_exists( 'synergia_select_vc_row_map' ) ) {
	/**
	 * Map VC Row shortcode
	 * Hooks on vc_after_init action
	 */
	function synergia_select_vc_row_map() {
		
		/******* VC Row shortcode - begin *******/
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Select Row Content Width', 'synergia' ),
				'value'      => array(
					esc_html__( 'Full Width', 'synergia' ) => 'full-width',
					esc_html__( 'In Grid', 'synergia' )    => 'grid'
				),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'anchor',
				'heading'     => esc_html__( 'Select Anchor ID', 'synergia' ),
				'description' => esc_html__( 'For example "home"', 'synergia' ),
				'group'       => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Select Background Color', 'synergia' ),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Select Background Image', 'synergia' ),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Select Disable Background Image', 'synergia' ),
				'value'       => array(
					esc_html__( 'Never', 'synergia' )        => '',
					esc_html__( 'Below 1280px', 'synergia' ) => '1280',
					esc_html__( 'Below 1024px', 'synergia' ) => '1024',
					esc_html__( 'Below 768px', 'synergia' )  => '768',
					esc_html__( 'Below 680px', 'synergia' )  => '680',
					esc_html__( 'Below 480px', 'synergia' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'synergia' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'parallax_background_image',
				'heading'    => esc_html__( 'Select Parallax Background Image', 'synergia' ),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_bg_speed',
				'heading'     => esc_html__( 'Select Parallax Speed', 'synergia' ),
				'description' => esc_html__( 'Set your parallax speed. Default value is 1.', 'synergia' ),
				'dependency'  => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'textfield',
				'param_name' => 'parallax_bg_height',
				'heading'    => esc_html__( 'Select Parallax Section Height (px)', 'synergia' ),
				'dependency' => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Select Content Aligment', 'synergia' ),
				'value'      => array(
					esc_html__( 'Default', 'synergia' ) => '',
					esc_html__( 'Left', 'synergia' )    => 'left',
					esc_html__( 'Center', 'synergia' )  => 'center',
					esc_html__( 'Right', 'synergia' )   => 'right'
				),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		/******* VC Row shortcode - end *******/
		
		/******* VC Row Inner shortcode - begin *******/
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Select Row Content Width', 'synergia' ),
				'value'      => array(
					esc_html__( 'Full Width', 'synergia' ) => 'full-width',
					esc_html__( 'In Grid', 'synergia' )    => 'grid'
				),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Select Background Color', 'synergia' ),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Select Background Image', 'synergia' ),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Select Disable Background Image', 'synergia' ),
				'value'       => array(
					esc_html__( 'Never', 'synergia' )        => '',
					esc_html__( 'Below 1280px', 'synergia' ) => '1280',
					esc_html__( 'Below 1024px', 'synergia' ) => '1024',
					esc_html__( 'Below 768px', 'synergia' )  => '768',
					esc_html__( 'Below 680px', 'synergia' )  => '680',
					esc_html__( 'Below 480px', 'synergia' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'synergia' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Select Content Aligment', 'synergia' ),
				'value'      => array(
					esc_html__( 'Default', 'synergia' ) => '',
					esc_html__( 'Left', 'synergia' )    => 'left',
					esc_html__( 'Center', 'synergia' )  => 'center',
					esc_html__( 'Right', 'synergia' )   => 'right'
				),
				'group'      => esc_html__( 'Select Settings', 'synergia' )
			)
		);
		
		/******* VC Row Inner shortcode - end *******/
		
		/******* VC Revolution Slider shortcode - begin *******/
		
		if ( synergia_select_revolution_slider_installed() ) {
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'enable_paspartu',
					'heading'     => esc_html__( 'Select Enable Passepartout', 'synergia' ),
					'value'       => array_flip( synergia_select_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'group'       => esc_html__( 'Select Settings', 'synergia' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'paspartu_size',
					'heading'     => esc_html__( 'Select Passepartout Size', 'synergia' ),
					'value'       => array(
						esc_html__( 'Tiny', 'synergia' )   => 'tiny',
						esc_html__( 'Small', 'synergia' )  => 'small',
						esc_html__( 'Normal', 'synergia' ) => 'normal',
						esc_html__( 'Large', 'synergia' )  => 'large'
					),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Select Settings', 'synergia' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_side_paspartu',
					'heading'     => esc_html__( 'Select Disable Side Passepartout', 'synergia' ),
					'value'       => array_flip( synergia_select_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Select Settings', 'synergia' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_top_paspartu',
					'heading'     => esc_html__( 'Select Disable Top Passepartout', 'synergia' ),
					'value'       => array_flip( synergia_select_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Select Settings', 'synergia' )
				)
			);
		}
		
		/******* VC Revolution Slider shortcode - end *******/
	}
	
	add_action( 'vc_after_init', 'synergia_select_vc_row_map' );
}