<?php

if ( ! function_exists( 'synergia_select_register_sidebars' ) ) {
	/**
	 * Function that registers theme's sidebars
	 */
	function synergia_select_register_sidebars() {
		
		register_sidebar(
			array(
				'id'            => 'sidebar',
				'name'          => esc_html__( 'Sidebar', 'synergia' ),
				'description'   => esc_html__( 'Default Sidebar', 'synergia' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="qodef-widget-title-holder"><h5 class="qodef-widget-title">',
				'after_title'   => '</h5></div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'synergia_select_register_sidebars', 1 );
}

if ( ! function_exists( 'synergia_select_add_support_custom_sidebar' ) ) {
	/**
	 * Function that adds theme support for custom sidebars. It also creates SynergiaSelectSidebar object
	 */
	function synergia_select_add_support_custom_sidebar() {
		add_theme_support( 'SynergiaSelectSidebar' );
		
		if ( get_theme_support( 'SynergiaSelectSidebar' ) ) {
			new SynergiaSelectSidebar();
		}
	}
	
	add_action( 'after_setup_theme', 'synergia_select_add_support_custom_sidebar' );
}