<?php

if ( ! function_exists( 'synergia_select_sidebar_options_map' ) ) {
	function synergia_select_sidebar_options_map() {
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'synergia' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = synergia_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'synergia' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		synergia_select_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'synergia' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'synergia' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => synergia_select_get_custom_sidebars_options()
		) );
		
		$synergia_custom_sidebars = synergia_select_get_custom_sidebars();
		if ( count( $synergia_custom_sidebars ) > 0 ) {
			synergia_select_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'synergia' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'synergia' ),
				'parent'      => $sidebar_panel,
				'options'     => $synergia_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_sidebar_options_map', 9 );
}