<?php

if ( ! function_exists( 'synergia_select_sidearea_options_map' ) ) {
	function synergia_select_sidearea_options_map() {
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '_side_area_page',
				'title' => esc_html__( 'Side Area', 'synergia' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$side_area_panel = synergia_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Side Area', 'synergia' ),
				'name'  => 'side_area',
				'page'  => '_side_area_page'
			)
		);
		
		$side_area_icon_style_group = synergia_select_add_admin_group(
			array(
				'parent'      => $side_area_panel,
				'name'        => 'side_area_icon_style_group',
				'title'       => esc_html__( 'Side Area Icon Style', 'synergia' ),
				'description' => esc_html__( 'Define styles for Side Area icon', 'synergia' )
			)
		);
		
		$side_area_icon_style_row1 = synergia_select_add_admin_row(
			array(
				'parent' => $side_area_icon_style_group,
				'name'   => 'side_area_icon_style_row1'
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row1,
				'type'   => 'colorsimple',
				'name'   => 'side_area_icon_color',
				'label'  => esc_html__( 'Color', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row1,
				'type'   => 'colorsimple',
				'name'   => 'side_area_icon_hover_color',
				'label'  => esc_html__( 'Hover Color', 'synergia' )
			)
		);
		
		$side_area_icon_style_row2 = synergia_select_add_admin_row(
			array(
				'parent' => $side_area_icon_style_group,
				'name'   => 'side_area_icon_style_row2',
				'next'   => true
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row2,
				'type'   => 'colorsimple',
				'name'   => 'side_area_close_icon_color',
				'label'  => esc_html__( 'Close Icon Color', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row2,
				'type'   => 'colorsimple',
				'name'   => 'side_area_close_icon_hover_color',
				'label'  => esc_html__( 'Close Icon Hover Color', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent'        => $side_area_panel,
				'type'          => 'text',
				'name'          => 'side_area_width',
				'default_value' => '',
				'label'         => esc_html__( 'Side Area Width', 'synergia' ),
				'description'   => esc_html__( 'Enter a width for Side Area', 'synergia' ),
				'args'          => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent'      => $side_area_panel,
				'type'        => 'color',
				'name'        => 'side_area_background_color',
				'label'       => esc_html__( 'Background Color', 'synergia' ),
				'description' => esc_html__( 'Choose a background color for Side Area', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent'      => $side_area_panel,
				'type'        => 'text',
				'name'        => 'side_area_padding',
				'label'       => esc_html__( 'Padding', 'synergia' ),
				'description' => esc_html__( 'Define padding for Side Area in format top right bottom left', 'synergia' ),
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent'        => $side_area_panel,
				'type'          => 'selectblank',
				'name'          => 'side_area_aligment',
				'default_value' => '',
				'label'         => esc_html__( 'Text Alignment', 'synergia' ),
				'description'   => esc_html__( 'Choose text alignment for side area', 'synergia' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'synergia' ),
					'left'   => esc_html__( 'Left', 'synergia' ),
					'center' => esc_html__( 'Center', 'synergia' ),
					'right'  => esc_html__( 'Right', 'synergia' )
				)
			)
		);
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_sidearea_options_map', 13 );
}