<?php

if ( ! function_exists( 'synergia_select_search_body_class' ) ) {
	/**
	 * Function that adds body classes for different search types
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function synergia_select_search_body_class( $classes ) {
		$classes[] = 'qodef-search-covers-header';
		
		return $classes;
	}
	
	add_filter( 'body_class', 'synergia_select_search_body_class' );
}

if ( ! function_exists( 'synergia_select_get_search' ) ) {
	/**
	 * Loads search HTML based on search type option.
	 */
	function synergia_select_get_search() {
		synergia_select_load_search_template();
	}
	
	add_action( 'synergia_select_before_page_header_html_close', 'synergia_select_get_search' );
	add_action( 'synergia_select_before_mobile_header_html_close', 'synergia_select_get_search' );
}

if ( ! function_exists( 'synergia_select_load_search_template' ) ) {
	/**
	 * Loads search HTML based on search type option.
	 */
	function synergia_select_load_search_template() {
		$search_icon       = '';
		$search_icon_close = '';
		
		$search_in_grid   = synergia_select_options()->getOptionValue( 'search_in_grid' ) == 'yes' ? true : false;
		$search_icon_pack = synergia_select_options()->getOptionValue( 'search_icon_pack' );
		
		if ( ! empty( $search_icon_pack ) ) {
			$search_icon       = synergia_select_icon_collections()->getSearchIcon( $search_icon_pack, true );
			$search_icon_close = synergia_select_icon_collections()->getSearchClose( $search_icon_pack, true );
		}
		
		$parameters = array(
			'search_in_grid'    => $search_in_grid,
			'search_icon'       => $search_icon,
			'search_icon_close' => $search_icon_close
		);
		
		synergia_select_get_module_template_part( 'types/covers-header/templates/covers-header', 'search', '', $parameters );
	}
}