<?php

if ( ! function_exists( 'synergia_select_header_minimal_full_screen_menu_body_class' ) ) {
	/**
	 * Function that adds body classes for different full screen menu types
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function synergia_select_header_minimal_full_screen_menu_body_class( $classes ) {
		$classes[] = 'qodef-' . synergia_select_options()->getOptionValue( 'fullscreen_menu_animation_style' );
		
		return $classes;
	}
	
	if ( synergia_select_check_is_header_type_enabled( 'header-minimal', synergia_select_get_page_id() ) ) {
		add_filter( 'body_class', 'synergia_select_header_minimal_full_screen_menu_body_class' );
	}
}

if ( ! function_exists( 'synergia_select_get_header_minimal_full_screen_menu' ) ) {
	/**
	 * Loads fullscreen menu HTML template
	 */
	function synergia_select_get_header_minimal_full_screen_menu() {
		$parameters = array(
			'fullscreen_menu_in_grid' => synergia_select_options()->getOptionValue( 'fullscreen_in_grid' ) === 'yes' ? true : false
		);
		
		synergia_select_get_module_template_part( 'templates/full-screen-menu', 'header/types/header-minimal', '', $parameters );
	}
	
	if ( synergia_select_check_is_header_type_enabled( 'header-minimal', synergia_select_get_page_id() ) ) {
		add_action( 'synergia_select_after_wrapper_inner', 'synergia_select_get_header_minimal_full_screen_menu', 40 );
	}
}

if ( ! function_exists( 'synergia_select_header_minimal_mobile_menu_module' ) ) {
    /**
     * Function that edits module for mobile menu
     *
     * @param $module - default module value
     *
     * @return string name of module
     */
    function synergia_select_header_minimal_mobile_menu_module( $module ) {
        return 'header/types/header-minimal';
    }

    if ( synergia_select_check_is_header_type_enabled( 'header-minimal', synergia_select_get_page_id() ) ) {
        add_filter('synergia_select_mobile_menu_module', 'synergia_select_header_minimal_mobile_menu_module');
    }
}

if ( ! function_exists( 'synergia_select_header_minimal_mobile_menu_slug' ) ) {
    /**
     * Function that edits slug for mobile menu
     *
     * @param $slug - default slug value
     *
     * @return string name of slug
     */
    function synergia_select_header_minimal_mobile_menu_slug( $slug ) {
        return 'minimal';
    }

    if ( synergia_select_check_is_header_type_enabled( 'header-minimal', synergia_select_get_page_id() ) ) {
        add_filter('synergia_select_mobile_menu_slug', 'synergia_select_header_minimal_mobile_menu_slug');
    }
}