<?php

if ( ! function_exists( 'synergia_select_footer_options_map' ) ) {
	function synergia_select_footer_options_map() {
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'synergia' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);
		
		$footer_panel = synergia_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'synergia' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'synergia' ),
				'parent'        => $footer_panel,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'synergia' ),
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#qodef_show_footer_top_container'
				),
				'parent'        => $footer_panel,
			)
		);
		
		$show_footer_top_container = synergia_select_add_admin_container(
			array(
				'name'            => 'show_footer_top_container',
				'hidden_property' => 'show_footer_top',
				'hidden_value'    => 'no',
				'parent'          => $footer_panel
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '4',
				'label'         => esc_html__( 'Footer Top Columns', 'synergia' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'synergia' ),
				'options'       => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4'
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'synergia' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'synergia' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'synergia' ),
					'left'   => esc_html__( 'Left', 'synergia' ),
					'center' => esc_html__( 'Center', 'synergia' ),
					'right'  => esc_html__( 'Right', 'synergia' )
				),
				'parent'        => $show_footer_top_container,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'        => 'footer_top_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'synergia' ),
				'description' => esc_html__( 'Set background color for top footer area', 'synergia' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'synergia' ),
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#qodef_show_footer_bottom_container'
				),
				'parent'        => $footer_panel,
			)
		);
		
		$show_footer_bottom_container = synergia_select_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'hidden_property' => 'show_footer_bottom',
				'hidden_value'    => 'no',
				'parent'          => $footer_panel
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '2',
				'label'         => esc_html__( 'Footer Bottom Columns', 'synergia' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'synergia' ),
				'options'       => array(
					'1' => '1',
					'2' => '2',
					'3' => '3'
				),
				'parent'        => $show_footer_bottom_container,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'        => 'footer_bottom_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'synergia' ),
				'description' => esc_html__( 'Set background color for bottom footer area', 'synergia' ),
				'parent'      => $show_footer_bottom_container
			)
		);
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_footer_options_map', 5 );
}