<?php

if ( ! function_exists( 'synergia_select_map_footer_meta' ) ) {
	function synergia_select_map_footer_meta() {
		
		$footer_meta_box = synergia_select_add_meta_box(
			array(
				'scope' => apply_filters( 'synergia_select_set_scope_for_meta_boxes', array( 'page', 'post' ), 'footer_meta' ),
				'title' => esc_html__( 'Footer', 'synergia' ),
				'name'  => 'footer_meta'
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_disable_footer_meta',
				'type'          => 'select',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Footer for this Page', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will hide footer on this page', 'synergia' ),
				'options'       => synergia_select_get_yes_no_select_array( false ),
				'parent'        => $footer_meta_box,
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						'no'  => '',
						'yes' => '#qodef_qodef_show_footer_meta_container'
					),
					'show'       => array(
						'no'  => '#qodef_qodef_show_footer_meta_container',
						'yes' => ''
					)
				)
			)
		);
		
		$show_footer_meta_container = synergia_select_add_admin_container(
			array(
				'name'            => 'qodef_show_footer_meta_container',
				'hidden_property' => 'qodef_disable_footer_meta',
				'hidden_value'    => 'yes',
				'parent'          => $footer_meta_box
			)
		);
		
			synergia_select_add_meta_box_field(
				array(
					'name'          => 'qodef_show_footer_top_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Top', 'synergia' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'synergia' ),
					'options'       => synergia_select_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
			
			synergia_select_add_meta_box_field(
				array(
					'name'          => 'qodef_show_footer_bottom_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Bottom', 'synergia' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'synergia' ),
					'options'       => synergia_select_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_footer_meta', 70 );
}