<?php

if ( ! function_exists( 'synergia_select_map_content_bottom_meta' ) ) {
	function synergia_select_map_content_bottom_meta() {
		
		$content_bottom_meta_box = synergia_select_add_meta_box(
			array(
				'scope' => apply_filters( 'synergia_select_set_scope_for_meta_boxes', array( 'page', 'post' ), 'content_bottom_meta' ),
				'title' => esc_html__( 'Content Bottom', 'synergia' ),
				'name'  => 'content_bottom_meta'
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_enable_content_bottom_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Content Bottom Area', 'synergia' ),
				'description'   => esc_html__( 'This option will enable Content Bottom area on pages', 'synergia' ),
				'parent'        => $content_bottom_meta_box,
				'options'       => synergia_select_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''   => '#qodef_qodef_show_content_bottom_meta_container',
						'no' => '#qodef_qodef_show_content_bottom_meta_container'
					),
					'show'       => array(
						'yes' => '#qodef_qodef_show_content_bottom_meta_container'
					)
				)
			)
		);
		
		$show_content_bottom_meta_container = synergia_select_add_admin_container(
			array(
				'parent'          => $content_bottom_meta_box,
				'name'            => 'qodef_show_content_bottom_meta_container',
				'hidden_property' => 'qodef_enable_content_bottom_area_meta',
				'hidden_values'   => array( '', 'no' )
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_content_bottom_sidebar_custom_display_meta',
				'type'          => 'selectblank',
				'default_value' => '',
				'label'         => esc_html__( 'Sidebar to Display', 'synergia' ),
				'description'   => esc_html__( 'Choose a content bottom sidebar to display', 'synergia' ),
				'options'       => synergia_select_get_custom_sidebars(),
				'parent'        => $show_content_bottom_meta_container,
				'args'          => array(
					'select2' => true
				)
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'type'          => 'select',
				'name'          => 'qodef_content_bottom_in_grid_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Display in Grid', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will place content bottom in grid', 'synergia' ),
				'options'       => synergia_select_get_yes_no_select_array(),
				'parent'        => $show_content_bottom_meta_container
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'type'        => 'color',
				'name'        => 'qodef_content_bottom_background_color_meta',
				'label'       => esc_html__( 'Background Color', 'synergia' ),
				'description' => esc_html__( 'Choose a background color for content bottom area', 'synergia' ),
				'parent'      => $show_content_bottom_meta_container
			)
		);
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_content_bottom_meta', 71 );
}