<?php

/*** Post Settings ***/

if ( ! function_exists( 'synergia_select_map_post_meta' ) ) {
	function synergia_select_map_post_meta() {
		
		$post_meta_box = synergia_select_add_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'synergia' ),
				'name'  => 'post-meta'
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'synergia' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'synergia' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => synergia_select_get_custom_sidebars_options( true )
			)
		);
		
		$synergia_custom_sidebars = synergia_select_get_custom_sidebars();
		if ( count( $synergia_custom_sidebars ) > 0 ) {
			synergia_select_add_meta_box_field( array(
				'name'        => 'qodef_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'synergia' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'synergia' ),
				'parent'      => $post_meta_box,
				'options'     => synergia_select_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		synergia_select_add_meta_box_field(
			array(
				'name'        => 'qodef_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'synergia' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'synergia' ),
				'parent'      => $post_meta_box
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_blog_masonry_gallery_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Fixed Proportion', 'synergia' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in fixed proportion', 'synergia' ),
				'default_value' => 'default',
				'parent'        => $post_meta_box,
				'options'       => array(
					'default'            => esc_html__( 'Default', 'synergia' ),
					'large-width'        => esc_html__( 'Large Width', 'synergia' ),
					'large-height'       => esc_html__( 'Large Height', 'synergia' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'synergia' )
				)
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_blog_masonry_gallery_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Original Proportion', 'synergia' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in original proportion', 'synergia' ),
				'default_value' => 'default',
				'parent'        => $post_meta_box,
				'options'       => array(
					'default'     => esc_html__( 'Default', 'synergia' ),
					'large-width' => esc_html__( 'Large Width', 'synergia' )
				)
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'synergia' ),
				'parent'        => $post_meta_box,
				'options'       => synergia_select_get_yes_no_select_array()
			)
		);

		do_action('synergia_select_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_post_meta', 20 );
}
