<?php

foreach ( glob( SELECT_FRAMEWORK_MODULES_ROOT_DIR . '/blog/admin/meta-boxes/*/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'synergia_select_map_blog_meta' ) ) {
	function synergia_select_map_blog_meta() {
		$qode_blog_categories = array();
		$categories           = get_categories();
		foreach ( $categories as $category ) {
			$qode_blog_categories[ $category->slug ] = $category->name;
		}
		
		$blog_meta_box = synergia_select_add_meta_box(
			array(
				'scope' => array( 'page' ),
				'title' => esc_html__( 'Blog', 'synergia' ),
				'name'  => 'blog_meta'
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'        => 'qodef_blog_category_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Blog Category', 'synergia' ),
				'description' => esc_html__( 'Choose category of posts to display (leave empty to display all categories)', 'synergia' ),
				'parent'      => $blog_meta_box,
				'options'     => $qode_blog_categories
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'        => 'qodef_show_posts_per_page_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Posts', 'synergia' ),
				'description' => esc_html__( 'Enter the number of posts to display', 'synergia' ),
				'parent'      => $blog_meta_box,
				'options'     => $qode_blog_categories,
				'args'        => array( "col_width" => 3 )
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'        => 'qodef_blog_masonry_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Layout', 'synergia' ),
				'description' => esc_html__( 'Set masonry layout. Default is in grid.', 'synergia' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''           => esc_html__( 'Default', 'synergia' ),
					'in-grid'    => esc_html__( 'In Grid', 'synergia' ),
					'full-width' => esc_html__( 'Full Width', 'synergia' )
				)
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'        => 'qodef_blog_masonry_number_of_columns_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Number of Columns', 'synergia' ),
				'description' => esc_html__( 'Set number of columns for your masonry blog lists', 'synergia' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''      => esc_html__( 'Default', 'synergia' ),
					'two'   => esc_html__( '2 Columns', 'synergia' ),
					'three' => esc_html__( '3 Columns', 'synergia' ),
					'four'  => esc_html__( '4 Columns', 'synergia' ),
					'five'  => esc_html__( '5 Columns', 'synergia' )
				)
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'        => 'qodef_blog_masonry_space_between_items_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Space Between Items', 'synergia' ),
				'description' => esc_html__( 'Set space size between posts for your masonry blog lists', 'synergia' ),
				'options'     => synergia_select_get_space_between_items_array( true ),
				'parent'      => $blog_meta_box
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_blog_list_featured_image_proportion_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Featured Image Proportion', 'synergia' ),
				'description'   => esc_html__( 'Choose type of proportions you want to use for featured images on masonry blog lists', 'synergia' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''         => esc_html__( 'Default', 'synergia' ),
					'fixed'    => esc_html__( 'Fixed', 'synergia' ),
					'original' => esc_html__( 'Original', 'synergia' )
				)
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'name'          => 'qodef_blog_pagination_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Pagination Type', 'synergia' ),
				'description'   => esc_html__( 'Choose a pagination layout for Blog Lists', 'synergia' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''                => esc_html__( 'Default', 'synergia' ),
					'standard'        => esc_html__( 'Standard', 'synergia' ),
					'load-more'       => esc_html__( 'Load More', 'synergia' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'synergia' ),
					'no-pagination'   => esc_html__( 'No Pagination', 'synergia' )
				)
			)
		);
		
		synergia_select_add_meta_box_field(
			array(
				'type'          => 'text',
				'name'          => 'qodef_number_of_chars_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Number of Words in Excerpt', 'synergia' ),
				'description'   => esc_html__( 'Enter a number of words in excerpt (article summary). Default value is 40', 'synergia' ),
				'parent'        => $blog_meta_box,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_blog_meta', 30 );
}