<?php

if ( ! function_exists( 'synergia_select_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function synergia_select_reset_options_map() {
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'synergia' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = synergia_select_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'synergia' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'synergia' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_reset_options_map', 100 );
}