<?php

if ( ! function_exists( 'synergia_select_general_options_map' ) ) {
	/**
	 * General options page
	 */
	function synergia_select_general_options_map() {
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '',
				'title' => esc_html__( 'General', 'synergia' ),
				'icon'  => 'fa fa-institution'
			)
		);
		
		$panel_design_style = synergia_select_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_design_style',
				'title' => esc_html__( 'Design Style', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'google_fonts',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__( 'Google Font Family', 'synergia' ),
				'description'   => esc_html__( 'Choose a default Google font for your site', 'synergia' ),
				'parent'        => $panel_design_style
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'additional_google_fonts',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Additional Google Fonts', 'synergia' ),
				'parent'        => $panel_design_style,
				'args'          => array(
					"dependence"             => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#qodef_additional_google_fonts_container"
				)
			)
		);
		
		$additional_google_fonts_container = synergia_select_add_admin_container(
			array(
				'parent'          => $panel_design_style,
				'name'            => 'additional_google_fonts_container',
				'hidden_property' => 'additional_google_fonts',
				'hidden_value'    => 'no'
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'additional_google_font1',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'synergia' ),
				'description'   => esc_html__( 'Choose additional Google font for your site', 'synergia' ),
				'parent'        => $additional_google_fonts_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'additional_google_font2',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'synergia' ),
				'description'   => esc_html__( 'Choose additional Google font for your site', 'synergia' ),
				'parent'        => $additional_google_fonts_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'additional_google_font3',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'synergia' ),
				'description'   => esc_html__( 'Choose additional Google font for your site', 'synergia' ),
				'parent'        => $additional_google_fonts_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'additional_google_font4',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'synergia' ),
				'description'   => esc_html__( 'Choose additional Google font for your site', 'synergia' ),
				'parent'        => $additional_google_fonts_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'additional_google_font5',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'synergia' ),
				'description'   => esc_html__( 'Choose additional Google font for your site', 'synergia' ),
				'parent'        => $additional_google_fonts_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'google_font_weight',
				'type'          => 'checkboxgroup',
				'default_value' => '',
				'label'         => esc_html__( 'Google Fonts Style & Weight', 'synergia' ),
				'description'   => esc_html__( 'Choose a default Google font weights for your site. Impact on page load time', 'synergia' ),
				'parent'        => $panel_design_style,
				'options'       => array(
					'100'  => esc_html__( '100 Thin', 'synergia' ),
					'100i' => esc_html__( '100 Thin Italic', 'synergia' ),
					'200'  => esc_html__( '200 Extra-Light', 'synergia' ),
					'200i' => esc_html__( '200 Extra-Light Italic', 'synergia' ),
					'300'  => esc_html__( '300 Light', 'synergia' ),
					'300i' => esc_html__( '300 Light Italic', 'synergia' ),
					'400'  => esc_html__( '400 Regular', 'synergia' ),
					'400i' => esc_html__( '400 Regular Italic', 'synergia' ),
					'500'  => esc_html__( '500 Medium', 'synergia' ),
					'500i' => esc_html__( '500 Medium Italic', 'synergia' ),
					'600'  => esc_html__( '600 Semi-Bold', 'synergia' ),
					'600i' => esc_html__( '600 Semi-Bold Italic', 'synergia' ),
					'700'  => esc_html__( '700 Bold', 'synergia' ),
					'700i' => esc_html__( '700 Bold Italic', 'synergia' ),
					'800'  => esc_html__( '800 Extra-Bold', 'synergia' ),
					'800i' => esc_html__( '800 Extra-Bold Italic', 'synergia' ),
					'900'  => esc_html__( '900 Ultra-Bold', 'synergia' ),
					'900i' => esc_html__( '900 Ultra-Bold Italic', 'synergia' )
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'google_font_subset',
				'type'          => 'checkboxgroup',
				'default_value' => '',
				'label'         => esc_html__( 'Google Fonts Subset', 'synergia' ),
				'description'   => esc_html__( 'Choose a default Google font subsets for your site', 'synergia' ),
				'parent'        => $panel_design_style,
				'options'       => array(
					'latin'        => esc_html__( 'Latin', 'synergia' ),
					'latin-ext'    => esc_html__( 'Latin Extended', 'synergia' ),
					'cyrillic'     => esc_html__( 'Cyrillic', 'synergia' ),
					'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'synergia' ),
					'greek'        => esc_html__( 'Greek', 'synergia' ),
					'greek-ext'    => esc_html__( 'Greek Extended', 'synergia' ),
					'vietnamese'   => esc_html__( 'Vietnamese', 'synergia' )
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'        => 'first_color',
				'type'        => 'color',
				'label'       => esc_html__( 'First Main Color', 'synergia' ),
				'description' => esc_html__( 'Choose the most dominant theme color. Default color is #fd75b4', 'synergia' ),
				'parent'      => $panel_design_style
			)
		);

		synergia_select_add_admin_field(
			array(
				'name'        => 'second_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Second Main Color', 'synergia' ),
				'description' => esc_html__( 'Choose the most dominant theme hover color. Default color is #00ebb4', 'synergia' ),
				'parent'      => $panel_design_style
			)
		);

		synergia_select_add_admin_field(
			array(
				'name'        => 'first_main_hover_color',
				'type'        => 'color',
				'label'       => esc_html__( 'First Main Hover Color', 'synergia' ),
				'description' => esc_html__( 'Choose the second most dominant theme color. Default color is #1c3467', 'synergia' ),
				'parent'      => $panel_design_style
			)
		);

		synergia_select_add_admin_field(
			array(
				'name'        => 'second_main_hover_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Second Main Hover Color', 'synergia' ),
				'description' => esc_html__( 'Choose the second most dominant theme hover color. Default color is #01f8be', 'synergia' ),
				'parent'      => $panel_design_style
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'        => 'page_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Page Background Color', 'synergia' ),
				'description' => esc_html__( 'Choose the background color for page content. Default color is #ffffff', 'synergia' ),
				'parent'      => $panel_design_style
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'        => 'selection_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Text Selection Color', 'synergia' ),
				'description' => esc_html__( 'Choose the color users see when selecting text', 'synergia' ),
				'parent'      => $panel_design_style
			)
		);

        $group_gradient = synergia_select_add_admin_group(array(
            'name'        => 'group_gradient',
            'title'       => esc_html__('Gradient Colors', 'synergia'),
            'description' => esc_html__('Define colors for gradient styles', 'synergia'),
            'parent'      => $panel_design_style
        ));

        $row_gradient_style1 = synergia_select_add_admin_row(array(
            'name'   => 'row_gradient_style1',
            'parent' => $group_gradient
        ));

        synergia_select_add_admin_field(array(
            'type'          => 'colorsimple',
            'name'          => 'gradient_style1_start_color',
            'default_value' => '',
            'label'         => esc_html__('Style 1 - Start Color (def. #d948ea)', 'synergia'),
            'parent'        => $row_gradient_style1
        ));

        synergia_select_add_admin_field(array(
            'type'          => 'colorsimple',
            'name'          => 'gradient_style1_end_color',
            'default_value' => '',
            'label'         => esc_html__('Style 1 - End Color (def. #ff7396)', 'synergia'),
            'parent'        => $row_gradient_style1
        ));
		
		/***************** Passepartout Layout - begin **********************/
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'boxed',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Boxed Layout', 'synergia' ),
				'parent'        => $panel_design_style,
				'args'          => array(
					"dependence"             => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#qodef_boxed_container"
				)
			)
		);
		
			$boxed_container = synergia_select_add_admin_container(
				array(
					'parent'          => $panel_design_style,
					'name'            => 'boxed_container',
					'hidden_property' => 'boxed',
					'hidden_value'    => 'no'
				)
			);
		
				synergia_select_add_admin_field(
					array(
						'name'        => 'page_background_color_in_box',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'synergia' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'synergia' ),
						'parent'      => $boxed_container
					)
				);
				
				synergia_select_add_admin_field(
					array(
						'name'        => 'boxed_background_image',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'synergia' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'synergia' ),
						'parent'      => $boxed_container
					)
				);
				
				synergia_select_add_admin_field(
					array(
						'name'        => 'boxed_pattern_background_image',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'synergia' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'synergia' ),
						'parent'      => $boxed_container
					)
				);
				
				synergia_select_add_admin_field(
					array(
						'name'          => 'boxed_background_image_attachment',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Attachment', 'synergia' ),
						'description'   => esc_html__( 'Choose background image attachment', 'synergia' ),
						'parent'        => $boxed_container,
						'options'       => array(
							''       => esc_html__( 'Default', 'synergia' ),
							'fixed'  => esc_html__( 'Fixed', 'synergia' ),
							'scroll' => esc_html__( 'Scroll', 'synergia' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'paspartu',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Passepartout', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'synergia' ),
				'parent'        => $panel_design_style,
				'args'          => array(
					"dependence"             => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#qodef_paspartu_container"
				)
			)
		);
		
			$paspartu_container = synergia_select_add_admin_container(
				array(
					'parent'          => $panel_design_style,
					'name'            => 'paspartu_container',
					'hidden_property' => 'paspartu',
					'hidden_value'    => 'no'
				)
			);
		
				synergia_select_add_admin_field(
					array(
						'name'        => 'paspartu_color',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'synergia' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'synergia' ),
						'parent'      => $paspartu_container
					)
				);
				
				synergia_select_add_admin_field(
					array(
						'name'        => 'paspartu_width',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'synergia' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'synergia' ),
						'parent'      => $paspartu_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				synergia_select_add_admin_field(
					array(
						'name'        => 'paspartu_responsive_width',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'synergia' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'synergia' ),
						'parent'      => $paspartu_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				synergia_select_add_admin_field(
					array(
						'parent'        => $paspartu_container,
						'type'          => 'yesno',
						'default_value' => 'no',
						'name'          => 'disable_top_paspartu',
						'label'         => esc_html__( 'Disable Top Passepartout', 'synergia' )
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Content Layout - begin **********************/
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'initial_content_width',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'synergia' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'synergia' ),
				'parent'        => $panel_design_style,
				'options'       => array(
					'qodef-grid-1100' => esc_html__( '1100px - default', 'synergia' ),
					'qodef-grid-1300' => esc_html__( '1300px', 'synergia' ),
					'qodef-grid-1200' => esc_html__( '1200px', 'synergia' ),
					'qodef-grid-1000' => esc_html__( '1000px', 'synergia' ),
					'qodef-grid-800'  => esc_html__( '800px', 'synergia' )
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'preload_pattern_image',
				'type'          => 'image',
				'label'         => esc_html__( 'Preload Pattern Image', 'synergia' ),
				'description'   => esc_html__( 'Choose preload pattern image to be displayed until images are loaded', 'synergia' ),
				'parent'        => $panel_design_style
			)
		);
		
		/***************** Content Layout - end **********************/
		
		$panel_settings = synergia_select_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_settings',
				'title' => esc_html__( 'Settings', 'synergia' )
			)
		);
		
		/***************** Smooth Scroll Layout - begin **********************/
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'page_smooth_scroll',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Smooth Scroll', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices)', 'synergia' ),
				'parent'        => $panel_settings
			)
		);
		
		/***************** Smooth Scroll Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'smooth_page_transitions',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Smooth Page Transitions', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'synergia' ),
				'parent'        => $panel_settings,
				'args'          => array(
					"dependence"             => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#qodef_page_transitions_container"
				)
			)
		);
		
			$page_transitions_container = synergia_select_add_admin_container(
				array(
					'parent'          => $panel_settings,
					'name'            => 'page_transitions_container',
					'hidden_property' => 'smooth_page_transitions',
					'hidden_value'    => 'no'
				)
			);
		
				synergia_select_add_admin_field(
					array(
						'name'          => 'page_transition_preloader',
						'type'          => 'yesno',
						'default_value' => 'no',
						'label'         => esc_html__( 'Enable Preloading Animation', 'synergia' ),
						'description'   => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'synergia' ),
						'parent'        => $page_transitions_container,
						'args'          => array(
							"dependence"             => true,
							"dependence_hide_on_yes" => "",
							"dependence_show_on_yes" => "#qodef_page_transition_preloader_container"
						)
					)
				);
				
				$page_transition_preloader_container = synergia_select_add_admin_container(
					array(
						'parent'          => $page_transitions_container,
						'name'            => 'page_transition_preloader_container',
						'hidden_property' => 'page_transition_preloader',
						'hidden_value'    => 'no'
					)
				);
		
		
					synergia_select_add_admin_field(
						array(
							'name'   => 'smooth_pt_bgnd_color',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'synergia' ),
							'parent' => $page_transition_preloader_container
						)
					);
					
					$group_pt_spinner_animation = synergia_select_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation',
							'title'       => esc_html__( 'Loader Style', 'synergia' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'synergia' ),
							'parent'      => $page_transition_preloader_container
						)
					);
					
					$row_pt_spinner_animation = synergia_select_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation',
							'parent' => $group_pt_spinner_animation
						)
					);
					
					synergia_select_add_admin_field(
						array(
							'type'          => 'selectsimple',
							'name'          => 'smooth_pt_spinner_type',
							'default_value' => '',
							'label'         => esc_html__( 'Spinner Type', 'synergia' ),
							'parent'        => $row_pt_spinner_animation,
							'options'       => array(
								'synergia'        		=> esc_html__( 'Synergia', 'synergia' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'synergia' ),
								'pulse'                 => esc_html__( 'Pulse', 'synergia' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'synergia' ),
								'cube'                  => esc_html__( 'Cube', 'synergia' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'synergia' ),
								'stripes'               => esc_html__( 'Stripes', 'synergia' ),
								'wave'                  => esc_html__( 'Wave', 'synergia' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'synergia' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'synergia' ),
								'atom'                  => esc_html__( 'Atom', 'synergia' ),
								'clock'                 => esc_html__( 'Clock', 'synergia' ),
								'mitosis'               => esc_html__( 'Mitosis', 'synergia' ),
								'lines'                 => esc_html__( 'Lines', 'synergia' ),
								'fussion'               => esc_html__( 'Fussion', 'synergia' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'synergia' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'synergia' )
							)
						)
					);
					
					synergia_select_add_admin_field(
						array(
							'type'          => 'colorsimple',
							'name'          => 'smooth_pt_spinner_color',
							'default_value' => '',
							'label'         => esc_html__( 'Spinner Color', 'synergia' ),
							'parent'        => $row_pt_spinner_animation
						)
					);
					
					synergia_select_add_admin_field(
						array(
							'name'          => 'page_transition_fadeout',
							'type'          => 'yesno',
							'default_value' => 'no',
							'label'         => esc_html__( 'Enable Fade Out Animation', 'synergia' ),
							'description'   => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'synergia' ),
							'parent'        => $page_transitions_container
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'show_back_button',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show "Back To Top Button"', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will display a Back to Top button on every page', 'synergia' ),
				'parent'        => $panel_settings
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'responsiveness',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Responsiveness', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will make all pages responsive', 'synergia' ),
				'parent'        => $panel_settings
			)
		);
		
		$panel_custom_code = synergia_select_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_custom_code',
				'title' => esc_html__( 'Custom Code', 'synergia' )
			)
		);

		synergia_select_add_admin_field(
			array(
				'name'        => 'custom_js',
				'type'        => 'textarea',
				'label'       => esc_html__( 'Custom JS', 'synergia' ),
				'description' => esc_html__( 'Enter your custom Javascript here', 'synergia' ),
				'parent'      => $panel_custom_code
			)
		);
		
		$panel_google_api = synergia_select_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_google_api',
				'title' => esc_html__( 'Google API', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'        => 'google_maps_api_key',
				'type'        => 'text',
				'label'       => esc_html__( 'Google Maps Api Key', 'synergia' ),
				'description' => esc_html__( 'Insert your Google Maps API key here. For instructions on how to create a Google Maps API key, please refer to our to our documentation.', 'synergia' ),
				'parent'      => $panel_google_api
			)
		);
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_general_options_map', 1 );
}

if ( ! function_exists( 'synergia_select_page_general_style' ) ) {
	/**
	 * Function that prints page general inline styles
	 */
	function synergia_select_page_general_style( $style ) {
		$current_style = '';
		$page_id       = synergia_select_get_page_id();
		$class_prefix  = synergia_select_get_unique_page_class( $page_id );
		
		$boxed_background_style = array();
		
		$boxed_page_background_color = synergia_select_get_meta_field_intersect( 'page_background_color_in_box', $page_id );
		if ( ! empty( $boxed_page_background_color ) ) {
			$boxed_background_style['background-color'] = $boxed_page_background_color;
		}
		
		$boxed_page_background_image = synergia_select_get_meta_field_intersect( 'boxed_background_image', $page_id );
		if ( ! empty( $boxed_page_background_image ) ) {
			$boxed_background_style['background-image']    = 'url(' . esc_url( $boxed_page_background_image ) . ')';
			$boxed_background_style['background-position'] = 'center 0px';
			$boxed_background_style['background-repeat']   = 'no-repeat';
		}
		
		$boxed_page_background_pattern_image = synergia_select_get_meta_field_intersect( 'boxed_pattern_background_image', $page_id );
		if ( ! empty( $boxed_page_background_pattern_image ) ) {
			$boxed_background_style['background-image']    = 'url(' . esc_url( $boxed_page_background_pattern_image ) . ')';
			$boxed_background_style['background-position'] = '0px 0px';
			$boxed_background_style['background-repeat']   = 'repeat';
		}
		
		$boxed_page_background_attachment = synergia_select_get_meta_field_intersect( 'boxed_background_image_attachment', $page_id );
		if ( ! empty( $boxed_page_background_attachment ) ) {
			$boxed_background_style['background-attachment'] = $boxed_page_background_attachment;
		}
		
		$boxed_background_selector = $class_prefix . '.qodef-boxed .qodef-wrapper';
		
		if ( ! empty( $boxed_background_style ) ) {
			$current_style .= synergia_select_dynamic_css( $boxed_background_selector, $boxed_background_style );
		}
		
		$paspartu_style     = array();
		$paspartu_res_style = array();
		$paspartu_res_start = '@media only screen and (max-width: 1024px) {';
		$paspartu_res_end   = '}';
		
		$paspartu_color = synergia_select_get_meta_field_intersect( 'paspartu_color', $page_id );
		if ( ! empty( $paspartu_color ) ) {
			$paspartu_style['background-color'] = $paspartu_color;
		}
		
		$paspartu_width = synergia_select_get_meta_field_intersect( 'paspartu_width', $page_id );
		if ( $paspartu_width !== '' ) {
			if ( synergia_select_string_ends_with( $paspartu_width, '%' ) || synergia_select_string_ends_with( $paspartu_width, 'px' ) ) {
				$paspartu_style['padding'] = $paspartu_width;
			} else {
				$paspartu_style['padding'] = $paspartu_width . 'px';
			}
		}
		
		$paspartu_selector = $class_prefix . '.qodef-paspartu-enabled .qodef-wrapper';
		
		if ( ! empty( $paspartu_style ) ) {
			$current_style .= synergia_select_dynamic_css( $paspartu_selector, $paspartu_style );
		}
		
		$paspartu_responsive_width = synergia_select_get_meta_field_intersect( 'paspartu_responsive_width', $page_id );
		if ( $paspartu_responsive_width !== '' ) {
			if ( synergia_select_string_ends_with( $paspartu_responsive_width, '%' ) || synergia_select_string_ends_with( $paspartu_responsive_width, 'px' ) ) {
				$paspartu_res_style['padding'] = $paspartu_responsive_width;
			} else {
				$paspartu_res_style['padding'] = $paspartu_responsive_width . 'px';
			}
		}
		
		if ( ! empty( $paspartu_res_style ) ) {
			$current_style .= $paspartu_res_start . synergia_select_dynamic_css( $paspartu_selector, $paspartu_res_style ) . $paspartu_res_end;
		}
		
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'synergia_select_add_page_custom_style', 'synergia_select_page_general_style' );
}