<?php

if (!function_exists('synergia_select_design_styles')) {
    /**
     * Generates general custom styles
     */
    function synergia_select_design_styles() {
        $font_family = synergia_select_options()->getOptionValue('google_fonts');
        if (!empty($font_family) && synergia_select_is_font_option_valid($font_family)) {
            $font_family_selector = array(
                'body'
            );
            echo synergia_select_dynamic_css($font_family_selector, array('font-family' => synergia_select_get_font_option_val($font_family)));
        }

	    // first main color -- start

        $first_main_color = synergia_select_options()->getOptionValue('first_color');
        if (!empty($first_main_color)) {
            $color_selector = array(


	            '.qodef-owl-slider .owl-nav .owl-next:hover',
	            '.qodef-owl-slider .owl-nav .owl-prev:hover',
	            '.widget.widget_rss .qodef-widget-title .rsswidget:hover',
	            '.widget.widget_search button:hover',
	            '.qodef-page-footer .widget a:hover',
	            '.qodef-page-footer .widget.widget_rss .qodef-footer-widget-title .rsswidget:hover',
	            '.qodef-page-footer .widget.widget_search button:hover',
	            '.qodef-side-menu .widget a:hover',
	            '.qodef-side-menu .widget.widget_rss .qodef-footer-widget-title .rsswidget:hover',
	            '.qodef-side-menu .widget.widget_search button:hover',
	            '.qodef-side-menu .widget.widget_tag_cloud a:hover',
	            '.qodef-top-bar a:hover',
	            '.qodef-icon-widget-holder .qodef-icon-element',
	            '.widget.widget_qodef_twitter_widget .qodef-twitter-widget.qodef-twitter-standard li .qodef-twitter-icon',
	            '.widget.widget_qodef_twitter_widget .qodef-twitter-widget.qodef-twitter-slider li .qodef-tweet-text a',
	            '.widget.widget_qodef_twitter_widget .qodef-twitter-widget.qodef-twitter-slider li .qodef-tweet-text span',
	            '.widget.widget_qodef_twitter_widget .qodef-twitter-widget.qodef-twitter-standard li .qodef-tweet-text a:hover',
	            '.widget.widget_qodef_twitter_widget .qodef-twitter-widget.qodef-twitter-slider li .qodef-twitter-icon i',
	            '.widget_icl_lang_sel_widget .wpml-ls-legacy-dropdown .wpml-ls-item-toggle:hover',
	            '.widget_icl_lang_sel_widget .wpml-ls-legacy-dropdown-click .wpml-ls-item-toggle:hover',
	            '.qodef-blog-holder article.sticky .qodef-post-title a',
	            '.qodef-bl-standard-pagination ul li.qodef-bl-pag-active a',
	            '.qodef-blog-pagination ul li a.qodef-pag-active',
	            '.qodef-author-description .qodef-author-description-text-holder .qodef-author-name a:hover',
	            '.qodef-author-description .qodef-author-description-text-holder .qodef-author-social-icons a:hover',
	            '.qodef-blog-single-navigation .qodef-blog-single-next:hover',
	            '.qodef-blog-single-navigation .qodef-blog-single-prev:hover',
	            '.qodef-single-links-pages .qodef-single-links-pages-inner>span',
	            '.qodef-main-menu ul li a:hover',
	            '.qodef-drop-down .second .inner ul li.current-menu-ancestor>a',
	            '.qodef-drop-down .second .inner ul li.current-menu-item>a',
	            '.qodef-drop-down .wide .second .inner>ul>li.current-menu-ancestor>a',
	            '.qodef-drop-down .wide .second .inner>ul>li.current-menu-item>a',
	            'nav.qodef-fullscreen-menu ul li.current-menu-ancestor>a',
	            'nav.qodef-fullscreen-menu ul li.current-menu-item>a',
	            'nav.qodef-fullscreen-menu ul li:hover>a',
	            'nav.qodef-fullscreen-menu>ul>li.qodef-active-item>a',
	            '.qodef-header-vertical .qodef-vertical-menu ul li a:hover',
	            '.qodef-header-vertical .qodef-vertical-menu ul li.current-menu-ancestor>a',
	            '.qodef-header-vertical .qodef-vertical-menu ul li.current-menu-item>a',
	            '.qodef-header-vertical .qodef-vertical-menu ul li.current_page_item>a',
	            '.qodef-header-vertical .qodef-vertical-menu ul li.qodef-active-item>a',
	            '.qodef-mobile-header .qodef-mobile-menu-opener.qodef-mobile-menu-opened a',
	            '.qodef-mobile-header .qodef-mobile-nav .qodef-grid>ul>li.qodef-active-item>a',
	            '.qodef-mobile-header .qodef-mobile-nav .qodef-grid>ul>li.qodef-active-item>h6',
	            '.qodef-mobile-header .qodef-mobile-nav ul li a:hover',
	            '.qodef-mobile-header .qodef-mobile-nav ul li h6:hover',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-ancestor>a',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-ancestor>h6',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-item>a',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-item>h6',
	            '.qodef-search-page-holder article.sticky .qodef-post-title a',
	            '.qodef-search-cover .qodef-search-close a:hover',
	            '.qodef-side-menu-button-opener.opened',
	            '.qodef-side-menu-button-opener:hover',
	            '.qodef-title-holder.qodef-breadcrumbs-type .qodef-breadcrumbs a:hover',
	            '.qodef-title-holder.qodef-standard-with-breadcrumbs-type .qodef-breadcrumbs a:hover',
	            '.qodef-portfolio-single-holder .qodef-ps-info-holder .qodef-ps-info-item .qodef-social-share-holder a:hover',
	            '.qodef-pl-standard-pagination ul li.qodef-pl-pag-active a',
	            '.qodef-testimonials-holder.qodef-testimonials-light .owl-nav .owl-next:hover',
	            '.qodef-testimonials-holder.qodef-testimonials-light .owl-nav .owl-prev:hover',
	            '.qodef-btn.qodef-btn-outline',
	            '.qodef-btn.qodef-btn-icon_box',
	            '.qodef-social-share-holder.qodef-list li a:hover',
	            '.qodef-social-share-holder.qodef-dropdown .qodef-social-share-dropdown-opener:hover',
	            '.qodef-team.main-info-below-image .qodef-team-social-wrapp .qodef-icon-shortcode span:hover',
	            '.qodef-team.main-info-below-image.info-below-image-boxed .qodef-team-social-wrapp .qodef-icon-shortcode .flip-icon-holder .icon-normal span',
	            '.qodef-team.main-info-below-image.info-below-image-standard .qodef-team-social-wrapp .qodef-icon-shortcode .flip-icon-holder .icon-flip span',
	            '.qodef-team.main-info-on-hover .qodef-team-info-wrapper .qodef-team-social-wrapp span a:hover',
	            '.qodef-twitter-list-holder .qodef-twitter-icon',
	            '.qodef-twitter-list-holder .qodef-tweet-text a:hover',
	            '.qodef-twitter-list-holder .qodef-twitter-profile a:hover'
            );

            $woo_color_selector = array();
            if (synergia_select_is_woocommerce_installed()) {
                $woo_color_selector = array(
	                '.woocommerce-page .qodef-content .qodef-quantity-buttons .qodef-quantity-minus:hover',
	                '.woocommerce-page .qodef-content .qodef-quantity-buttons .qodef-quantity-plus:hover',
	                'div.woocommerce .qodef-quantity-buttons .qodef-quantity-minus:hover',
	                'div.woocommerce .qodef-quantity-buttons .qodef-quantity-plus:hover',
	                '.widget.woocommerce.widget_layered_nav ul li.chosen a',
	                '.widget.woocommerce.widget_product_search .woocommerce-product-search button:hover'
                );
            }

            $color_selector = array_merge($color_selector, $woo_color_selector);

            $color_important_selector = array(
                '.qodef-portfolio-list-holder.qodef-pl-hover-overlay-background article .qodef-pli-text .qodef-pli-category-holder a:hover'
            );

            $background_color_selector = array(

	            '.qodef-st-loader .pulse',
	            '.qodef-st-loader .double_pulse .double-bounce1',
	            '.qodef-st-loader .double_pulse .double-bounce2',
	            '.qodef-st-loader .cube',
	            '.qodef-st-loader .rotating_cubes .cube1',
	            '.qodef-st-loader .rotating_cubes .cube2',
	            '.qodef-st-loader .stripes>div',
	            '.qodef-st-loader .wave>div',
	            '.qodef-st-loader .two_rotating_circles .dot1',
	            '.qodef-st-loader .two_rotating_circles .dot2',
	            '.qodef-st-loader .five_rotating_circles .container1>div',
	            '.qodef-st-loader .five_rotating_circles .container2>div',
	            '.qodef-st-loader .five_rotating_circles .container3>div',
	            '.qodef-st-loader .lines .line1',
	            '.qodef-st-loader .lines .line2',
	            '.qodef-st-loader .lines .line3',
	            '.qodef-st-loader .lines .line4',
	            '.qodef-newsform .qodef-newsform-submit',
	            '.widget #wp-calendar td#today',
	            '.qodef-social-icons-group-widget.qodef-square-icons .qodef-social-icon-widget-holder:hover',
	            '.qodef-social-icons-group-widget.qodef-square-icons.qodef-light-skin .qodef-social-icon-widget-holder:hover',
	            '.qodef-blog-holder article.format-audio .qodef-blog-audio-holder .mejs-container .mejs-controls>.mejs-time-rail .mejs-time-total .mejs-time-current',
	            '.qodef-blog-holder article.format-audio .qodef-blog-audio-holder .mejs-container .mejs-controls>a.mejs-horizontal-volume-slider .mejs-horizontal-volume-current',
	            '.qodef-page-footer .widget_nav_menu li a:hover:before',
	            '.qodef-main-menu>ul>li>a>span.item_outer:before',
	            '.qodef-drop-down .second .inner ul li a .item_outer:before',
	            '.qodef-drop-down .second .inner ul.right li a .item_outer:before',
	            '.qodef-search-fade .qodef-fullscreen-with-sidebar-search-holder .qodef-fullscreen-search-table',
	            '#multiscroll-nav ul li a.active',
	            '.qodef-light-header #multiscroll-nav ul li a.active',
	            '.qodef-dark-header #multiscroll-nav ul li a.active'

            );

            $woo_background_color_selector = array();
            if (synergia_select_is_woocommerce_installed()) {
                $woo_background_color_selector = array(
	                '.qodef-shopping-cart-holder .qodef-header-cart .qodef-cart-icon .qodef-cart-number'
                );
            }

            $background_color_selector = array_merge($background_color_selector, $woo_background_color_selector);

	        $background_color_important_selector = array(
		        '.qodef-btn.qodef-btn-outline:not(.qodef-btn-custom-hover-bg):hover'
	        );

            $border_color_selector = array(
	            '.qodef-st-loader .pulse_circles .ball',
	            '.qodef-btn.qodef-btn-outline'
            );

	        $border_color_important_selector = array(
	        	'.qodef-btn.qodef-btn-outline:not(.qodef-btn-custom-border-hover):hover',
	        );

            echo synergia_select_dynamic_css($color_selector, array('color' => $first_main_color));
            echo synergia_select_dynamic_css($color_important_selector, array('color' => $first_main_color . '!important'));
            echo synergia_select_dynamic_css($background_color_selector, array('background-color' => $first_main_color));
            echo synergia_select_dynamic_css($background_color_important_selector, array('background-color' => $first_main_color. '!important'));
            echo synergia_select_dynamic_css($border_color_selector, array('border-color' => $first_main_color));
            echo synergia_select_dynamic_css($border_color_important_selector, array('border-color' => $first_main_color . '!important'));
        }

        // first main color -- end

        // second main color -- start

	    $second_main_color = synergia_select_options()->getOptionValue('second_color');
	    if (!empty($second_main_color)) {
		    $color_selector = array(
			    'blockquote:before',
			    '.qodef-side-menu a.qodef-close-side-menu:hover',
			    '.qodef-testimonials-holder .qodef-label .qodef-label-text',
			    '.qodef-price-table .qodef-pt-inner ul li.qodef-pt-prices .qodef-pt-value',
			    '.qodef-price-table .qodef-pt-inner ul li.qodef-pt-prices .qodef-pt-price',
			    '.qodef-section-title-holder .qodef-label .qodef-label-text'
		    );

		    $woo_color_selector = array();
		    if (synergia_select_is_woocommerce_installed()) {
			    $woo_color_selector = array(
				    'ul.products>.product .price ins',
				    '.qodef-woo-single-page .qodef-single-product-summary .price ins',
				    '.qodef-shopping-cart-dropdown .qodef-cart-bottom .qodef-subtotal-holder .qodef-total-amount',
				    '.qodef-pls-holder .qodef-pls-text .qodef-pls-price ins',
				    '.qodef-pl-holder .qodef-pli .qodef-pli-price ins'
			    );
		    }

		    $color_selector = array_merge($color_selector, $woo_color_selector);

		    $background_color_selector = array(
			    '.qodef-comment-form .form-submit>input#submit_comment',
			    '.qodef-404-page .qodef-page-not-found .qodef-btn',
			    '.qodef-pl-load-more-holder .qodef-btn.qodef-btn-animated_solid',
			    '.qodef-testimonials-holder .qodef-label .qodef-label-line',
			    '.qodef-price-table .qodef-pt-inner ul li.qodef-pt-button .qodef-btn',
			    '.qodef-section-title-holder .qodef-label .qodef-label-line',
			    '.qodef-video-button-holder .qodef-video-button-play .qodef-video-button-play-icon:after'
		    );

		    $woo_background_color_selector = array();
		    if (synergia_select_is_woocommerce_installed()) {
			    $woo_background_color_selector = array(
				    '.woocommerce-page .qodef-content .wc-forward:not(.added_to_cart):not(.checkout-button)',
				    '.woocommerce-page .qodef-content a.added_to_cart',
				    '.woocommerce-page .qodef-content a.button',
				    '.woocommerce-page .qodef-content button[type=submit]:not(.qodef-woo-search-widget-button)',
				    '.woocommerce-page .qodef-content input[type=submit]',
				    'div.woocommerce .wc-forward:not(.added_to_cart):not(.checkout-button)',
				    'div.woocommerce a.added_to_cart',
				    'div.woocommerce a.button',
				    'div.woocommerce button[type=submit]:not(.qodef-woo-search-widget-button)',
				    'div.woocommerce input[type=submit]',
				    '.woocommerce .qodef-new-product',
				    '.qodef-shopping-cart-dropdown .qodef-cart-bottom .qodef-checkout',
				    '.widget.woocommerce.widget_price_filter .price_slider_wrapper .ui-widget-content .ui-slider-handle',
				    '.widget.woocommerce.widget_price_filter .price_slider_wrapper .ui-widget-content .ui-slider-range'
			    );
		    }

		    $background_color_selector = array_merge($background_color_selector, $woo_background_color_selector);

		    $border_color_selector = array(
			    '.qodef-404-page .qodef-page-not-found .qodef-btn'
		    );

		    echo synergia_select_dynamic_css($color_selector, array('color' => $second_main_color));
		    echo synergia_select_dynamic_css($background_color_selector, array('background-color' => $second_main_color));
		    echo synergia_select_dynamic_css($border_color_selector, array('border-color' => $second_main_color));
	    }

	    // second main color -- end

	    // first main hover color -- start

	    $first_main_hover_color = synergia_select_options()->getOptionValue('first_main_hover_color');

	    if (!empty($first_main_hover_color)) {

		    $link_hover_selector = array(
			    'a:hover',
			    'h1 a:hover',
			    'h2 a:hover',
			    'h3 a:hover',
			    'h4 a:hover',
			    'h5 a:hover',
			    'h6 a:hover',
			    'p a:hover',
			    '.qodef-comment-holder .qodef-comment-text .comment-edit-link:hover',
			    '.qodef-comment-holder .qodef-comment-text .comment-reply-link:hover',
			    '.qodef-comment-holder .qodef-comment-text .replay:hover',
			    '.qodef-blog-holder.qodef-blog-standard article .qodef-post-text .qodef-post-text-inner .qodef-post-info-bottom .qodef-post-info-bottom-left .qodef-post-info-comments-holder a:hover',
			    '.qodef-single-links-pages .qodef-single-links-pages-inner>a:hover',
			    '.qodef-portfolio-single-holder .qodef-ps-info-holder .qodef-ps-info-item a:hover',
			    '.qodef-ps-navigation .qodef-ps-back-btn a:hover',
			    '.qodef-portfolio-list-holder article .qodef-pli-text .qodef-pli-category-holder a:hover'

		    );

		    $link_hover_woo_selector = array();
		    if (synergia_select_is_woocommerce_installed()) {
			    $link_hover_woo_selector = array(
				    '.woocommerce-pagination .page-numbers li a.current',
				    '.woocommerce-pagination .page-numbers li a:hover',
				    '.woocommerce-pagination .page-numbers li span.current',
				    '.woocommerce-pagination .page-numbers li span:hover',
				    '.qodef-woo-view-all-pagination a:hover',
				    'ul.products>.product .qodef-pl-category a:hover',
				    '.qodef-woo-single-page .qodef-single-product-summary .product_meta>span a:hover',
				    '.qodef-pl-holder .qodef-pli .qodef-pli-title:hover a',
				    '.qodef-pl-holder .qodef-pli .qodef-pli-category a:hover',
			    );
		    }

		    $link_hover_selector = array_merge($link_hover_selector, $link_hover_woo_selector);

		    $link_color_important_selector = array(
			    '.qodef-iwt:not(.qodef-iwt-disable-title-hover) a:hover .qodef-iwt-title'
		    );

		    $link_background_hover_styles = array(
			    '#submit_comment:hover',
			    '.post-password-form input[type=submit]:hover',
			    'input.wpcf7-form-control.wpcf7-submit:hover',
			    '.qodef-blog-holder article .qodef-post-info-top>div a:hover',
			    '.qodef-blog-holder article.format-link .qodef-post-text:hover',
			    '.qodef-related-posts-holder .qodef-related-post .qodef-post-info>div a:hover',
			    '.qodef-blog-list-holder .qodef-bli-info>div a:hover',
			    '.qodef-btn.qodef-btn-animated_solid .qodef-btn-overlay'


		    );

		    $link_background_hover_woo_selector = array();
		    if (synergia_select_is_woocommerce_installed()) {
			    $link_background_hover_woo_selector = array(
				    'ul.products>.product .qodef-pl-inner .added_to_cart:hover',
				    'ul.products>.product .qodef-pl-inner .button:hover',
				    '.qodef-shopping-cart-dropdown .qodef-cart-bottom .qodef-view-cart:hover',
				    '.qodef-product-info .qodef-pi-add-to-cart a.added_to_cart:hover',
				    '.qodef-pl-holder.qodef-info-below-image .qodef-pli-add-to-cart>a:hover',
				    '.qodef-product-holder a.added_to_cart:hover',
			    );
		    }

		    $link_background_hover_styles = array_merge($link_background_hover_styles, $link_background_hover_woo_selector);

		    $link_background_important_hover_styles = array(
			    '.qodef-btn.qodef-btn-solid:not(.qodef-btn-custom-hover-bg):hover'
		    );

		    $link_border_hover_styles = array(
			    '.qodef-btn.qodef-btn-animated_solid .qodef-btn-overlay'
		    );

		    $link_border_important_hover_styles = array(
			    '.qodef-btn.qodef-btn-solid:not(.qodef-btn-custom-border-hover):hover'
		    );


		    echo synergia_select_dynamic_css( $link_hover_selector, array( 'color' => $first_main_hover_color ) );
		    echo synergia_select_dynamic_css( $link_color_important_selector, array( 'color' => $first_main_hover_color . '!important' ) );
		    echo synergia_select_dynamic_css( $link_background_hover_styles, array( 'background-color' => $first_main_hover_color ) );
		    echo synergia_select_dynamic_css( $link_background_important_hover_styles, array( 'background-color' => $first_main_hover_color . '!important' ) );
		    echo synergia_select_dynamic_css( $link_border_hover_styles, array( 'border-color' => $first_main_hover_color ) );
		    echo synergia_select_dynamic_css( $link_border_important_hover_styles, array( 'border-color' => $first_main_hover_color . '!important' ) );
	    }

	    // first main hover color -- end

	    // second main hover color -- start

	    $second_main_hover_color = synergia_select_options()->getOptionValue('second_main_hover_color');
	    if (!empty($second_main_hover_color)) {



		    $background_hover_styles = array(
			    '.qodef-comment-form .form-submit>input#submit_comment:hover',

		    );

		    $background_hover_woo_styles = array();
		    if (synergia_select_is_woocommerce_installed()) {
			    $background_hover_woo_styles = array(
				    '.qodef-pl-load-more-holder .qodef-btn.qodef-btn-animated_solid .qodef-btn-overlay',
				    '.woocommerce-page .qodef-content .wc-forward:not(.added_to_cart):not(.checkout-button):hover',
				    '.woocommerce-page .qodef-content a.added_to_cart:hover',
				    '.woocommerce-page .qodef-content a.button:hover',
				    '.woocommerce-page .qodef-content button[type=submit]:not(.qodef-woo-search-widget-button):hover',
				    '.woocommerce-page .qodef-content input[type=submit]:hover',
				    'div.woocommerce .wc-forward:not(.added_to_cart):not(.checkout-button):hover',
				    'div.woocommerce a.added_to_cart:hover',
				    'div.woocommerce a.button:hover',
				    'div.woocommerce button[type=submit]:not(.qodef-woo-search-widget-button):hover',
				    'div.woocommerce input[type=submit]:hover',
				    '.qodef-shopping-cart-dropdown .qodef-cart-bottom .qodef-checkout:hover',
			    );
		    }

		    $background_hover_styles = array_merge($background_hover_styles, $background_hover_woo_styles);


		    if (synergia_select_is_woocommerce_installed()) {

			    $background_important_hover_styles = array(
			    	'.qodef-price-table .qodef-pt-inner ul li.qodef-pt-button .qodef-btn:hover',
			    );

			    $border_important_hover_styles = array(
				    '.qodef-price-table .qodef-pt-inner ul li.qodef-pt-button .qodef-btn:hover',
			    );

			    echo synergia_select_dynamic_css( $background_important_hover_styles, array( 'background-color' => $second_main_hover_color . '!important' ) );
			    echo synergia_select_dynamic_css( $border_important_hover_styles, array( 'border-color' => $second_main_hover_color . '!important' ) );

		    }

		    echo synergia_select_dynamic_css( $background_hover_styles, array( 'background-color' => $second_main_hover_color ) );
	    }

	    // second main hover color -- end

        $page_background_color = synergia_select_options()->getOptionValue('page_background_color');
        if (!empty($page_background_color)) {
            $background_color_selector = array(
                'body',
                '.qodef-content'
            );
            echo synergia_select_dynamic_css($background_color_selector, array('background-color' => $page_background_color));
        }

        $selection_color = synergia_select_options()->getOptionValue('selection_color');
        if (!empty($selection_color)) {
            echo synergia_select_dynamic_css('::selection', array('background' => $selection_color));
            echo synergia_select_dynamic_css('::-moz-selection', array('background' => $selection_color));
        }

        $gradient_style1_start_color = synergia_select_options()->getOptionValue('gradient_style1_start_color');
        $gradient_style1_end_color = synergia_select_options()->getOptionValue('gradient_style1_end_color');

        if (!empty($gradient_style1_start_color) && !empty($gradient_style1_end_color)) {

            echo synergia_select_dynamic_css(array(
                    '.qodef-gradient-vertical',
                    '.qodef-tabs.qodef-tabs-standard .qodef-tabs-nav li.ui-state-active a .qodef-tab-nav-line',
                    '.qodef-tabs.qodef-tabs-standard .qodef-tabs-nav li.ui-state-hover a .qodef-tab-nav-line',
		            '#qodef-back-to-top > span:after',
		            '.qodef-drop-down .narrow .second .inner ul:before',
		            '.qodef-drop-down .wide .second:before')
                ,
                array(
                    'background' => '-webkit-linear-gradient(top,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                    'background' => '-o-linear-gradient(bottom,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                    'background' => '-moz-linear-gradient(bottom,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                    'background' => 'linear-gradient(to bottom,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                )
            );

            echo synergia_select_dynamic_css(
                array(
                    '.qodef-gradient-vertical-text',
                    '.qodef-gradient-vertical-text span',
                    '.qodef-gradient-vertical-text i',
                    '.qodef-gradient-vertical-text div',
                    '.qodef-tabs.qodef-tabs-standard .qodef-tabs-nav li.ui-state-active a .qodef-tab-title-text',
                    '.qodef-tabs.qodef-tabs-standard .qodef-tabs-nav li.ui-state-hover a .qodef-tab-title-text',
	                '.qodef-blog-holder article.format-quote .qodef-quote-author',
	                '.qodef-blog-holder article.format-quote .qodef-quote-author:before',
	                '.qodef-blog-holder.qodef-blog-standard article .qodef-post-text .qodef-post-text-inner .qodef-post-info-bottom .qodef-post-info-bottom-left .qodef-post-info-comments-holder a:before',
	                '.qodef-blog-holder.qodef-blog-standard article .qodef-post-text .qodef-post-text-inner .qodef-post-info-bottom .qodef-post-info-bottom-left .qodef-blog-like a i',
	                '.qodef-pl-filter-holder ul li.qodef-pl-current span',
	                '.qodef-pl-filter-holder ul li:hover span',
	                '.qodef-btn.qodef-btn-icon > i'
                ),
                array(
                    'background'              => '-webkit-linear-gradient(top,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                    'background'              => '-o-linear-gradient(bottom,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                    'background'              => '-moz-linear-gradient(bottom,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                    'background'              => 'linear-gradient(to bottom,' . $gradient_style1_start_color . ', ' . $gradient_style1_end_color . ')',
                    '-webkit-background-clip' => 'text'
                )
            );

            echo synergia_select_dynamic_css('.qodef-btn .qodef-btn-line.qodef-btn-line-bottom',
                array('background-color' => $gradient_style1_end_color)
            );

            echo synergia_select_dynamic_css('.qodef-btn .qodef-btn-line.qodef-btn-line-top',
                array('background-color' => $gradient_style1_start_color)
            );
        }


        $preload_background_styles = array();

        if (synergia_select_options()->getOptionValue('preload_pattern_image') !== "") {
            $preload_background_styles['background-image'] = 'url(' . synergia_select_options()->getOptionValue('preload_pattern_image') . ') !important';
        }

        echo synergia_select_dynamic_css('.qodef-preload-background', $preload_background_styles);
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_design_styles');
}

if (!function_exists('synergia_select_content_styles')) {
    function synergia_select_content_styles() {
        $content_style = array();

        $padding_top = synergia_select_options()->getOptionValue('content_top_padding');
        if ($padding_top !== '') {
            $content_style['padding-top'] = synergia_select_filter_px($padding_top) . 'px';
        }

        $content_selector = array(
            '.qodef-content .qodef-content-inner > .qodef-full-width > .qodef-full-width-inner',
        );

        echo synergia_select_dynamic_css($content_selector, $content_style);

        $content_style_in_grid = array();

        $padding_top_in_grid = synergia_select_options()->getOptionValue('content_top_padding_in_grid');
        if ($padding_top_in_grid !== '') {
            $content_style_in_grid['padding-top'] = synergia_select_filter_px($padding_top_in_grid) . 'px';
        }

        $content_selector_in_grid = array(
            '.qodef-content .qodef-content-inner > .qodef-container > .qodef-container-inner',
        );

        echo synergia_select_dynamic_css($content_selector_in_grid, $content_style_in_grid);
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_content_styles');
}

if (!function_exists('synergia_select_h1_styles')) {
    function synergia_select_h1_styles() {
        $margin_top = synergia_select_options()->getOptionValue('h1_margin_top');
        $margin_bottom = synergia_select_options()->getOptionValue('h1_margin_bottom');

        $item_styles = synergia_select_get_typography_styles('h1');

        if ($margin_top !== '') {
            $item_styles['margin-top'] = synergia_select_filter_px($margin_top) . 'px';
        }
        if ($margin_bottom !== '') {
            $item_styles['margin-bottom'] = synergia_select_filter_px($margin_bottom) . 'px';
        }

        $item_selector = array(
            'h1'
        );

        if (!empty($item_styles)) {
            echo synergia_select_dynamic_css($item_selector, $item_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_h1_styles');
}

if (!function_exists('synergia_select_h2_styles')) {
    function synergia_select_h2_styles() {
        $margin_top = synergia_select_options()->getOptionValue('h2_margin_top');
        $margin_bottom = synergia_select_options()->getOptionValue('h2_margin_bottom');

        $item_styles = synergia_select_get_typography_styles('h2');

        if ($margin_top !== '') {
            $item_styles['margin-top'] = synergia_select_filter_px($margin_top) . 'px';
        }
        if ($margin_bottom !== '') {
            $item_styles['margin-bottom'] = synergia_select_filter_px($margin_bottom) . 'px';
        }

        $item_selector = array(
            'h2'
        );

        if (!empty($item_styles)) {
            echo synergia_select_dynamic_css($item_selector, $item_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_h2_styles');
}

if (!function_exists('synergia_select_h3_styles')) {
    function synergia_select_h3_styles() {
        $margin_top = synergia_select_options()->getOptionValue('h3_margin_top');
        $margin_bottom = synergia_select_options()->getOptionValue('h3_margin_bottom');

        $item_styles = synergia_select_get_typography_styles('h3');

        if ($margin_top !== '') {
            $item_styles['margin-top'] = synergia_select_filter_px($margin_top) . 'px';
        }
        if ($margin_bottom !== '') {
            $item_styles['margin-bottom'] = synergia_select_filter_px($margin_bottom) . 'px';
        }

        $item_selector = array(
            'h3'
        );

        if (!empty($item_styles)) {
            echo synergia_select_dynamic_css($item_selector, $item_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_h3_styles');
}

if (!function_exists('synergia_select_h4_styles')) {
    function synergia_select_h4_styles() {
        $margin_top = synergia_select_options()->getOptionValue('h4_margin_top');
        $margin_bottom = synergia_select_options()->getOptionValue('h4_margin_bottom');

        $item_styles = synergia_select_get_typography_styles('h4');

        if ($margin_top !== '') {
            $item_styles['margin-top'] = synergia_select_filter_px($margin_top) . 'px';
        }
        if ($margin_bottom !== '') {
            $item_styles['margin-bottom'] = synergia_select_filter_px($margin_bottom) . 'px';
        }

        $item_selector = array(
            'h4'
        );

        if (!empty($item_styles)) {
            echo synergia_select_dynamic_css($item_selector, $item_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_h4_styles');
}

if (!function_exists('synergia_select_h5_styles')) {
    function synergia_select_h5_styles() {
        $margin_top = synergia_select_options()->getOptionValue('h5_margin_top');
        $margin_bottom = synergia_select_options()->getOptionValue('h5_margin_bottom');

        $item_styles = synergia_select_get_typography_styles('h5');

        if ($margin_top !== '') {
            $item_styles['margin-top'] = synergia_select_filter_px($margin_top) . 'px';
        }
        if ($margin_bottom !== '') {
            $item_styles['margin-bottom'] = synergia_select_filter_px($margin_bottom) . 'px';
        }

        $item_selector = array(
            'h5'
        );

        if (!empty($item_styles)) {
            echo synergia_select_dynamic_css($item_selector, $item_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_h5_styles');
}

if (!function_exists('synergia_select_h6_styles')) {
    function synergia_select_h6_styles() {
        $margin_top = synergia_select_options()->getOptionValue('h6_margin_top');
        $margin_bottom = synergia_select_options()->getOptionValue('h6_margin_bottom');

        $item_styles = synergia_select_get_typography_styles('h6');

        if ($margin_top !== '') {
            $item_styles['margin-top'] = synergia_select_filter_px($margin_top) . 'px';
        }
        if ($margin_bottom !== '') {
            $item_styles['margin-bottom'] = synergia_select_filter_px($margin_bottom) . 'px';
        }

        $item_selector = array(
            'h6'
        );

        if (!empty($item_styles)) {
            echo synergia_select_dynamic_css($item_selector, $item_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_h6_styles');
}

if (!function_exists('synergia_select_text_styles')) {
    function synergia_select_text_styles() {
        $item_styles = synergia_select_get_typography_styles('text');

        $item_selector = array(
            'p'
        );

        if (!empty($item_styles)) {
            echo synergia_select_dynamic_css($item_selector, $item_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_text_styles');
}

if (!function_exists('synergia_select_link_styles')) {
    function synergia_select_link_styles() {
        $link_styles = array();
        $link_color = synergia_select_options()->getOptionValue('link_color');
        $link_font_style = synergia_select_options()->getOptionValue('link_fontstyle');
        $link_font_weight = synergia_select_options()->getOptionValue('link_fontweight');
        $link_decoration = synergia_select_options()->getOptionValue('link_fontdecoration');

        if (!empty($link_color)) {
            $link_styles['color'] = $link_color;
        }
        if (!empty($link_font_style)) {
            $link_styles['font-style'] = $link_font_style;
        }
        if (!empty($link_font_weight)) {
            $link_styles['font-weight'] = $link_font_weight;
        }
        if (!empty($link_decoration)) {
            $link_styles['text-decoration'] = $link_decoration;
        }

        $link_selector = array(
            'a',
            'p a'
        );

        if (!empty($link_styles)) {
            echo synergia_select_dynamic_css($link_selector, $link_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_link_styles');
}

if (!function_exists('synergia_select_link_hover_styles')) {
    function synergia_select_link_hover_styles() {
        $link_hover_styles = array();
        $link_hover_color = synergia_select_options()->getOptionValue('link_hovercolor');
        $link_hover_decoration = synergia_select_options()->getOptionValue('link_hover_fontdecoration');

        if (!empty($link_hover_color)) {
            $link_hover_styles['color'] = $link_hover_color;
        }
        if (!empty($link_hover_decoration)) {
            $link_hover_styles['text-decoration'] = $link_hover_decoration;
        }

        $link_hover_selector = array(
            'a:hover',
            'p a:hover'
        );

        if (!empty($link_hover_styles)) {
            echo synergia_select_dynamic_css($link_hover_selector, $link_hover_styles);
        }

        $link_heading_hover_styles = array();

        if (!empty($link_hover_color)) {
            $link_heading_hover_styles['color'] = $link_hover_color;
        }

        $link_heading_hover_selector = array(
            'h1 a:hover',
            'h2 a:hover',
            'h3 a:hover',
            'h4 a:hover',
            'h5 a:hover',
            'h6 a:hover'
        );

        if (!empty($link_heading_hover_styles)) {
            echo synergia_select_dynamic_css($link_heading_hover_selector, $link_heading_hover_styles);
        }
    }

    add_action('synergia_select_style_dynamic', 'synergia_select_link_hover_styles');
}

if (!function_exists('synergia_select_smooth_page_transition_styles')) {
    function synergia_select_smooth_page_transition_styles($style) {
        $id = synergia_select_get_page_id();
        $loader_style = array();
        $current_style = '';

        $background_color = synergia_select_get_meta_field_intersect('smooth_pt_bgnd_color', $id);
        if (!empty($background_color)) {
            $loader_style['background-color'] = $background_color;
        }

        $loader_selector = array(
            '.qodef-smooth-transition-loader'
        );

        if (!empty($loader_style)) {
            $current_style .= synergia_select_dynamic_css($loader_selector, $loader_style);
        }

        $spinner_style = array();
        $spinner_color = synergia_select_get_meta_field_intersect('smooth_pt_spinner_color', $id);
        if (!empty($spinner_color)) {
            $spinner_style['background-color'] = $spinner_color;
        }

        $spinner_selectors = array(
            '.qodef-st-loader .qodef-rotate-circles > div',
            '.qodef-st-loader .pulse',
            '.qodef-st-loader .double_pulse .double-bounce1',
            '.qodef-st-loader .double_pulse .double-bounce2',
            '.qodef-st-loader .cube',
            '.qodef-st-loader .rotating_cubes .cube1',
            '.qodef-st-loader .rotating_cubes .cube2',
            '.qodef-st-loader .stripes > div',
            '.qodef-st-loader .wave > div',
            '.qodef-st-loader .two_rotating_circles .dot1',
            '.qodef-st-loader .two_rotating_circles .dot2',
            '.qodef-st-loader .five_rotating_circles .container1 > div',
            '.qodef-st-loader .five_rotating_circles .container2 > div',
            '.qodef-st-loader .five_rotating_circles .container3 > div',
            '.qodef-st-loader .atom .ball-1:before',
            '.qodef-st-loader .atom .ball-2:before',
            '.qodef-st-loader .atom .ball-3:before',
            '.qodef-st-loader .atom .ball-4:before',
            '.qodef-st-loader .clock .ball:before',
            '.qodef-st-loader .mitosis .ball',
            '.qodef-st-loader .lines .line1',
            '.qodef-st-loader .lines .line2',
            '.qodef-st-loader .lines .line3',
            '.qodef-st-loader .lines .line4',
            '.qodef-st-loader .fussion .ball',
            '.qodef-st-loader .fussion .ball-1',
            '.qodef-st-loader .fussion .ball-2',
            '.qodef-st-loader .fussion .ball-3',
            '.qodef-st-loader .fussion .ball-4',
            '.qodef-st-loader .wave_circles .ball',
            '.qodef-st-loader .pulse_circles .ball'
        );

        if (!empty($spinner_style)) {
            $current_style .= synergia_select_dynamic_css($spinner_selectors, $spinner_style);
        }

        $current_style = $current_style . $style;

        return $current_style;
    }

    add_filter('synergia_select_add_page_custom_style', 'synergia_select_smooth_page_transition_styles');
}