<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<?php
	/**
	 * synergia_select_header_meta hook
	 *
	 * @see synergia_select_header_meta() - hooked with 10
	 * @see synergia_select_user_scalable_meta - hooked with 10
	 * @see qodef_core_set_open_graph_meta - hooked with 10
	 */
	do_action( 'synergia_select_header_meta' );
	
	wp_head(); ?>
</head>
<body <?php body_class(); ?> itemscope itemtype="http://schema.org/WebPage">
	<?php
	/**
	 * synergia_select_after_body_tag hook
	 *
	 * @see synergia_select_get_side_area() - hooked with 10
	 * @see synergia_select_smooth_page_transitions() - hooked with 10
	 */
	do_action( 'synergia_select_after_body_tag' ); ?>
	
	<div class="qodef-wrapper qodef-404-page">
		<div class="qodef-wrapper-inner">
            <?php
            /**
             * synergia_select_after_wrapper_inner hook
             *
             * @see synergia_select_get_header() - hooked with 10
             * @see synergia_select_get_mobile_header() - hooked with 20
             * @see synergia_select_back_to_top_button() - hooked with 30
             * @see synergia_select_get_header_minimal_full_screen_menu() - hooked with 40
             * @see synergia_select_get_header_bottom_navigation() - hooked with 40
             */
            do_action( 'synergia_select_after_wrapper_inner' );

            do_action('synergia_select_before_main_content'); ?>
			
			<div class="qodef-content" <?php synergia_select_content_elem_style_attr(); ?>>
				<div class="qodef-content-inner">
					<div class="qodef-page-not-found">
						<?php
						$qodef_title_image_404 = synergia_select_options()->getOptionValue( '404_page_title_image' );
						$qodef_title_404       = synergia_select_options()->getOptionValue( '404_title' );
						$qodef_subtitle_404    = synergia_select_options()->getOptionValue( '404_subtitle' );
						$qodef_text_404        = synergia_select_options()->getOptionValue( '404_text' );
						$qodef_button_label    = synergia_select_options()->getOptionValue( '404_back_to_home' );
						
						if ( ! empty( $qodef_title_image_404 ) ) { ?>
							<div class="qodef-404-title-image">
								<img src="<?php echo esc_url( $qodef_title_image_404 ); ?>" alt="<?php esc_html_e( '404 Title Image', 'synergia' ); ?>" />
							</div>
						<?php } ?>
						
						<h1 class="qodef-404-title">
							<?php if ( ! empty( $qodef_title_404 ) ) {
								echo esc_html( $qodef_title_404 );
							} else {
								esc_html_e( '404', 'synergia' );
							} ?>
						</h1>
						
						<h3 class="qodef-404-subtitle">
							<?php if ( ! empty( $qodef_subtitle_404 ) ) {
								echo esc_html( $qodef_subtitle_404 );
							} else {
								esc_html_e( 'Oh no, This page has gone off the grid!', 'synergia' );
							} ?>
						</h3>
						
						<p class="qodef-404-text">
							<?php if ( ! empty( $qodef_text_404 ) ) {
								echo esc_html( $qodef_text_404 );
							} else {
								esc_html_e( '', 'synergia' );
							} ?>
						</p>
						
						<?php
							$button_params = array(
								'type' => 'animated_solid',
								'hover_background_color' => '#01f8be',
								'hover_border_color' => '#01f8be',
								'link' => esc_url( home_url( '/' ) ),
								'custom_class' => 'qodef-btn-custom-hover-bg',
								'text' => ! empty( $qodef_button_label ) ? $qodef_button_label : esc_html__( 'Back to homepage', 'synergia' )
							);
							
							echo synergia_select_return_button_html( $button_params );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php wp_footer(); ?>
</body>
</html>