<?php
/**
 * Team info below shortcode template
 */
?>
<div class="qodef-team main-info-below-image <?php echo esc_attr($skin) ?>">
	<div class="qodef-team-inner">
		<?php if ($team_image !== '') { ?>
			<div class="qodef-team-image">
                <?php echo wp_get_attachment_image($team_image,'full');?>
			</div>
		<?php } ?>

		<?php if ($team_name !== '' || $team_position !== '' || $team_description != "") { ?>
			<div class="qodef-team-info">
				<?php if ($team_name !== '' || $team_position !== '') { ?>
					<?php if ($team_position !== "") { ?>
						<h6 <?php synergia_select_class_attribute($position_classes); ?> <?php echo synergia_select_get_inline_style($position_styles); ?>><?php echo esc_attr($team_position) ?></h6>
					<?php } ?>
					<div class="qodef-team-title-holder">
						<?php if ($team_name !== '') { ?>
							<<?php echo esc_attr($team_name_tag); ?> class="qodef-team-name">
								<?php echo esc_attr($team_name); ?>
							</<?php echo esc_attr($team_name_tag); ?>>
						<?php } ?>
					</div>
				<?php } ?>

				<?php if ($team_description != "") { ?>
					<div class='qodef-team-text'>
						<div class='qodef-team-text-inner'>
							<div class='qodef-team-description'>
								<p><?php echo esc_attr($team_description) ?></p>
							</div>
						</div>
					</div>
				<?php }
			} ?>

		<div class="qodef-team-social-holder-between">
			<div class="qodef-team-social <?php echo esc_attr($team_social_icon_type) ?>">
				<div class="qodef-team-social-inner">
					<div class="qodef-team-social-wrapp">

						<?php foreach( $team_social_icons as $team_social_icon ) {
							print $team_social_icon;
						} ?>

					</div>
				</div>
			</div>
		</div>

		</div>
	</div>
</div>