<?php
namespace QodeCore\CPT\Shortcodes\Counter;

use QodeCore\Lib;

class Counter implements Lib\ShortcodeInterface
{
    private $base;

    public function __construct() {
        $this->base = 'qodef_counter';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if (function_exists('vc_map')) {
            vc_map(
                array(
                    'name'                      => esc_html__('Select Counter', 'select-core'),
                    'base'                      => $this->getBase(),
                    'category'                  => esc_html__('by Select', 'select-core'),
                    'icon'                      => 'icon-wpb-counter extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
                    'params'                    => array(
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'custom_class',
                            'heading'     => esc_html__('Custom CSS Class', 'select-core'),
                            'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS', 'select-core')
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'type',
                            'heading'     => esc_html__('Type', 'select-core'),
                            'value'       => array(
                                esc_html__('Zero Counter', 'select-core')   => 'qodef-zero-counter',
                                esc_html__('Random Counter', 'select-core') => 'qodef-random-counter'
                            ),
                            'save_always' => true,
                        ),
                        array(
                            'type'       => 'textfield',
                            'param_name' => 'digit',
                            'heading'    => esc_html__('Digit', 'select-core')
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'digit_color',
                            'heading'    => esc_html__('Digit Color', 'select-core'),
                            'dependency' => array('element' => 'digit', 'not_empty' => true)
                        ),
	                    array(
		                    'type'        => 'dropdown',
		                    'param_name'  => 'background_circle',
		                    'heading'     => esc_html__('Background Overlay', 'select-core'),
		                    'value'       => array(
			                    esc_html__('Yes', 'select-core')   => 'yes',
			                    esc_html__('No', 'select-core') => 'no'
		                    ),
		                    'save_always' => true,
	                    ),
                        array(
                            'type'       => 'textfield',
                            'param_name' => 'circle_size',
                            'heading'    => esc_html__('Circle Size (px)', 'select-core'),
                            'dependency' => array( 'element' => 'background_circle', 'value' => array( 'yes' ) )
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'background_color',
                            'heading'    => esc_html__('Background Color', 'select-core'),
                            'dependency' => array( 'element' => 'background_circle', 'value' => array( 'yes' ) )
                        ),
                        array(
                            'type'       => 'textfield',
                            'param_name' => 'title',
                            'heading'    => esc_html__('Title', 'select-core')
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'title_color',
                            'heading'    => esc_html__('Title Color', 'select-core'),
                            'dependency' => array('element' => 'title', 'not_empty' => true)
                        )
                    )
                )
            );
        }
    }

    public function render($atts, $content = null) {
        $args = array(
            'custom_class'     => '',
            'type'             => 'qodef-zero-counter',
            'digit'            => '123',
            'digit_color'      => '',
            'circle_size'      => '',
            'background_circle'=> 'yes',
            'background_color' => '',
            'title'            => '',
            'title_color'      => ''
        );
        $params = shortcode_atts($args, $atts);

        $params['holder_classes'] = $this->getHolderClasses($params);
        $params['holder_styles'] = $this->getHolderStyles($params);
        $params['counter_styles'] = $this->getCounterStyles($params);
        $params['counter_title_styles'] = $this->getCounterTitleStyles($params);

        $html = qodef_core_get_shortcode_module_template_part('templates/counter', 'counter', '', $params);

        return $html;
    }

    private function getHolderStyles($params) {
        $styles = array();

        if ( ! empty( $params['circle_size'] ) ) {
            $styles[] = 'width: ' . synergia_select_filter_px( $params['circle_size'] ) . 'px';
            $styles[] = 'height: ' . synergia_select_filter_px( $params['circle_size'] ) . 'px';
        }

        if ($params['background_circle'] == 'yes' && !empty($params['background_color'])) {
            $styles[] = 'background-color: ' . $params['background_color'];
        }

        return implode(';', $styles);
    }

    private function getHolderClasses($params) {
        $holderClasses = array();

        $holderClasses[] = !empty($params['custom_class']) ? esc_attr($params['custom_class']) : '';

        $holderClasses[] = $params['background_circle'] == 'no' ? 'qodef-counter-disable-overlay' : '';

        return implode(' ', $holderClasses);
    }

    private function getCounterStyles($params) {
        $styles = array();

        if (!empty($params['digit_color'])) {
            $styles[] = 'color: ' . $params['digit_color'];
        }

        return implode(';', $styles);
    }

    private function getCounterTitleStyles($params) {
        $styles = array();

        if (!empty($params['title_color'])) {
            $styles[] = 'color: ' . $params['title_color'];
        }

        return implode(';', $styles);
    }
}