/*! For license information please see rmpMain.js.LICENSE.txt */
(function(){var __webpack_modules__={"./assets/admin/scss/dark-mode.scss":function(){eval("// extracted by mini-css-extract-plugin\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/scss/dark-mode.scss?")},"./assets/admin/scss/wizard-ui.scss":function(){eval("// extracted by mini-css-extract-plugin\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/scss/wizard-ui.scss?")},"./assets/admin/js/rmp-admin.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * This is admin scripts file which contain the admin actions.\n *\n * @version 4.0.0\n *\n * @author Expresstech System\n *\n */\n\njQuery(document).ready(function (jQuery) {\n  /**\n   * Iframe loader and contents show/hide.\n   */\n  jQuery('#rmp-preview-iframe').on('load', function () {\n    jQuery('#rmp-preview-iframe-loader').hide();\n    jQuery('#rmp-menu-update-notification').remove();\n    jQuery('#rmp-preview-iframe').show();\n    jQuery('#rmp-preview-iframe').contents().find('a').on('click', function (e) {\n      e.stopPropagation();\n      e.preventDefault();\n      var url = jQuery(this).attr('href');\n\n      // Prevent to load the customizer page on preview aria.\n      if ('#' == url) {\n        return;\n      }\n      if (url.indexOf('?') >= 0) {\n        url = url + '&rmp_preview_mode=true';\n      } else {\n        url = url + '?rmp_preview_mode=true';\n      }\n      jQuery('#rmp-preview-iframe').attr('src', url);\n    });\n  });\n\n  /**\n   * Save the theme as template.\n   *\n   * @since 4.0.0\n   *\n   * @fires Click\n   */\n  jQuery('button#rmp-save-theme').on('click', function (e) {\n    e.stopPropagation();\n    e.preventDefault();\n    const themeName = jQuery('#rmp-save-theme-name').val();\n    if (3 > themeName.length) {\n      alert('Please give meaning full name to this theme');\n      return;\n    }\n    jQuery.ajax({\n      url: rmpObject.ajaxURL,\n      data: {\n        'action': 'rmp_save_theme',\n        'ajax_nonce': rmpObject.ajax_nonce,\n        'theme_name': themeName,\n        'menu_id': jQuery('#menu_id').val(),\n        'form': jQuery('#rmp-editor-form').serialize()\n      },\n      type: 'POST',\n      dataType: 'json',\n      error: function (error) {\n        console.log(error.statusText);\n      },\n      success: function (response) {\n        jQuery(e.target).parents('.rmp-dialog-contents').append('<div class=\"notice notice-success settings-error is-dismissible\"><p>' + response.data.message + '</p></div>');\n      }\n    });\n  });\n\n  /**\n   * Ajax call to save the menu settings when click on update.\n   *\n   * @version 4.0.0\n   *\n   * @fires click\n   */\n  jQuery(document).on('click', 'button#rmp-save-menu-options,#rmp-menu-quick-update-button', function (e) {\n    jQuery.ajax({\n      url: rmpObject.ajaxURL,\n      data: {\n        'action': 'rmp_save_menu_action',\n        'ajax_nonce': rmpObject.ajax_nonce,\n        'form': jQuery('#rmp-editor-form').serialize()\n      },\n      type: 'POST',\n      dataType: 'json',\n      beforeSend: function () {\n        jQuery('#rmp-preview-iframe-loader').show();\n      },\n      error: function (error) {\n        console.log(error.statusText);\n        jQuery('#rmp-preview-iframe-loader').hide();\n      },\n      success: function (response) {\n        // If options is updated successfully then reload the iframe.\n        if (response.success) {\n          const url = jQuery('#rmp-preview-iframe').attr('src');\n          jQuery('#rmp-preview-iframe').attr('src', url);\n        }\n      }\n    });\n  });\n\n  // Initiate the color picker instances.\n  jQuery('.rmp-color-input').wpColorPicker();\n\n  // Fix events glitch on color textbox.\n  jQuery('.rmp-color-input').removeAttr('style');\n  jQuery(document).find('.rmp-color-input').off('focus');\n\n  // Initiate the tab elements.\n  jQuery('.tabs,#rmp-setting-tabs').tabs({\n    hide: {\n      effect: 'explode',\n      duration: 1000\n    },\n    show: {\n      effect: 'explode',\n      duration: 800\n    },\n    active: 0\n  });\n\n  // Active tabs under ordering elements.\n  jQuery('.nav-tab-wrapper').on('click', '.nav-tab', function (e) {\n    jQuery('.nav-tab-wrapper .nav-tab').removeClass('nav-tab-active');\n    jQuery(this).addClass('nav-tab-active');\n  });\n\n  /**\n   * Hamburger element selector option hide and show.\n   */\n\n  hideShowSelect('#rmp-menu-button-position-type', '.rmp-menu-hamburger-selector-div', 'show', 'inside-element');\n  jQuery('#rmp-menu-button-position-type').on('change', function () {\n    hideShowSelect(this, '.rmp-menu-hamburger-selector-div', 'show', 'inside-element');\n  });\n\n  /**\n   * select hide show function\n   * @para string select, string show/hide Element, string show/hide\n   */\n  function hideShowSelect(checkElement, targetElement, condition, value) {\n    if (jQuery(checkElement).val() == value) {\n      if (condition == 'show') {\n        jQuery(targetElement).show();\n      } else {\n        jQuery(targetElement).hide();\n      }\n    } else {\n      if (condition == 'show') {\n        jQuery(targetElement).hide();\n      } else {\n        jQuery(targetElement).show();\n      }\n    }\n  }\n\n  /**\n   * Check open/close of device options switcher.\n   *\n   * @version 4.0.0\n   *\n   * @fires click\n   */\n  jQuery('.rmp-device-switcher').on('click', function () {\n    var isOpen = jQuery(this).hasClass('open');\n    if (isOpen) {\n      jQuery(this).removeClass('open');\n    } else {\n      jQuery('.rmp-device-switcher').removeClass('open');\n      jQuery(this).addClass('open');\n    }\n  });\n\n  /**\n   * Change the option when select a device.\n   *\n   * @version 4.0.0\n   *\n   * @fires click\n   */\n  jQuery('.rmp-device-switcher li').on('click', function () {\n    var selectedDevice = jQuery(this).attr('data-device');\n    var firstDevice = jQuery('.rmp-device-switcher li:first-child').attr('data-device');\n    if (selectedDevice != firstDevice) {\n      activeDeviceOptions(selectedDevice);\n      if ('desktop' == selectedDevice) {\n        jQuery('#rmp-preview-desktop').trigger('click');\n      } else if ('tablet' == selectedDevice) {\n        jQuery('#rmp-preview-tablet').trigger('click');\n      } else {\n        jQuery('#rmp-preview-mobile').trigger('click');\n      }\n    }\n  });\n\n  /**\n   * Active all the device options in editor.\n   *\n   * @version 4.0.0;\n   * @param {string} selectedDevice This device name which is active.\n   */\n  function activeDeviceOptions(selectedDevice) {\n    const firstDevice = jQuery('.rmp-device-switcher li:first-child').attr('data-device');\n    const selectedIcon = jQuery('.rmp-device-switcher li[data-device=' + selectedDevice + ']').html();\n    const firstIcon = jQuery('.rmp-device-switcher li:first-child').html();\n    jQuery('.rmp-device-switcher li').each(function () {\n      if (jQuery(this).attr('data-device') === selectedDevice) {\n        jQuery(this).html(firstIcon);\n        jQuery(this).attr('data-device', firstDevice);\n      } else if (jQuery(this).attr('data-device') === firstDevice) {\n        jQuery(this).html(selectedIcon);\n        jQuery(this).attr('data-device', selectedDevice);\n      }\n    });\n  }\n\n  /**\n   * Close the device switcher when mouseup other places.\n   *\n   * @version 4.0.0\n   *\n   * @fires mouseup\n   */\n  jQuery(document).on('mouseup', function (event) {\n    var target = event.target;\n    var deviceSwitcher = jQuery('.rmp-device-switcher');\n    if (!deviceSwitcher.is(target) && 0 === deviceSwitcher.has(target).length) {\n      deviceSwitcher.removeClass('open');\n    }\n  });\n\n  /**\n   * Active preview as per clicked device.\n   *\n   * @version 4.0.0\n   *\n   * @fires Click\n   */\n  jQuery('#rmp-editor-footer .rmp-preview-device-wrapper').on('click', 'button', function (e) {\n    jQuery('#rmp-editor-footer').find('.rmp-preview-device-wrapper button').removeClass('active');\n    jQuery('#rmp-editor-footer').find('.rmp-preview-device-wrapper button').attr('aria-pressed', 'false');\n    jQuery(this).addClass('active');\n    jQuery(this).attr('aria-pressed', 'true');\n    const device = jQuery(this).data('device');\n    const deviceEditor = jQuery('#rmp-editor-wrapper');\n    const allClasses = deviceEditor.attr('class').split(' ');\n    allClasses.forEach(function (value) {\n      if (value.includes('rmp-preview-')) {\n        deviceEditor.removeClass(value);\n      }\n    });\n    deviceEditor.addClass('rmp-preview-' + device);\n    activeDeviceOptions(device);\n  });\n\n  /**\n   * Instantiate the accordion elements.\n   * @version 4.0.0\n   */\n  jQuery('.rmp-accordion-container,.rmp-sub-accordion-container').accordion({\n    collapsible: true,\n    heightStyle: 'content',\n    animate: 200,\n    active: 0\n  });\n\n  /**\n   * Instantiate the draggable and sortable menu item order elements.\n   * \t@version 4.0.0\n   */\n  jQuery('#rmp-menu-ordering-items').accordion().sortable({\n    placeholder: 'sortable-placeholder',\n    opacity: 0.9,\n    cursor: 'move',\n    delay: 150,\n    forcePlaceholderSize: true,\n    active: false\n  });\n\n  /**\n   * Stop propagating when click on item control element.\n   */\n  jQuery('#tab-container .item-controls, #tab-header-bar .item-controls').on('click', function (event) {\n    event.stopPropagation();\n  });\n\n  /**\n   * Show/Hide tooltip for option description.\n   *\n   * @version 4.0.0\n   *\n   * @fires click,mouseleave\n   */\n  jQuery('.rmp-tooltip-icon').on('click', function (e) {\n    if (jQuery(this).hasClass('show-tooltip')) {\n      return;\n    } else {\n      jQuery(this).addClass('show-tooltip');\n    }\n    var toolTipContents = jQuery(this).find('.rmp-tooltip-content');\n    toolTipContents.css({\n      'left': e.pageX - toolTipContents.width() / 100 * 60,\n      'position': 'fixed',\n      'top': e.pageY - toolTipContents.height() - 10,\n      'bottom': 'unset'\n    });\n    toolTipContents.fadeIn();\n  }).on('mouseleave', function () {\n    jQuery(this).removeClass('show-tooltip');\n    jQuery(this).find('.rmp-tooltip-content').fadeOut();\n  });\n\n  /**\n   * Remove image from image picker\n   *\n   * @version 4.0.0\n   *\n   * @fires Click\n   */\n  jQuery('.rmp-image-picker ').on('click', '.rmp-image-picker-trash', function (e) {\n    e.stopPropagation();\n    e.preventDefault();\n    jQuery(this).parent('.rmp-image-picker').siblings('input.rmp-image-url-input').val('');\n    jQuery(this).parent('.rmp-image-picker').removeAttr('style');\n    jQuery(this).remove();\n    if (!jQuery('#rmp-editor-main').find('#rmp-menu-update-notification').length) {\n      addUpdateNotification();\n    }\n  });\n\n  /**\n   * Show/Hide the theme uploader section in theme page.\n   */\n  jQuery('#rmp-upload-new-theme').on('click', function () {\n    jQuery('#rmp-menu-library-import').toggleClass('hide');\n  });\n\n  /**\n   * Hide theme uploader section when click on cancel.\n   */\n  jQuery('#rmp-menu-library-import-form').on('click', '.cancel', function (e) {\n    jQuery('#rmp-menu-library-import').addClass('hide');\n  });\n\n  /**\n   * Upload the theme file using dropzone.\n   *\n   * @version 4.0.0\n   */\n  jQuery('#rmp-menu-library-import-form').dropzone({\n    clickable: true,\n    acceptedFiles: '.zip',\n    uploadMultiple: false,\n    success: function (file, response) {\n      location.reload();\n    },\n    totaluploadprogress: function () {\n      jQuery('.rmp-page-loader').css('display', 'flex');\n    }\n  });\n\n  /**\n   * Open theme options in editor footer.\n   */\n  jQuery('#rmp-theme-action').on('click', function (e) {\n    jQuery('#rmp-footer-theme-options').toggleClass('open');\n  });\n\n  /**\n   * Show/Hide the save theme wizard.\n   */\n  jQuery('.rmp-theme-save-button, #rmp-menu-save-theme-wizard .rmp-dialog-wrap .close').on('click', function (e) {\n    jQuery('#rmp-menu-save-theme-wizard').toggle();\n  });\n\n  /**\n   * Delete the theme from theme page.\n   */\n  jQuery('.rmp-theme-delete').on('click', function (e) {\n    e.preventDefault();\n\n    /** Ask for delete confirmation */\n    const isConfirm = confirm('Are you sure, You want to delete this theme ?');\n    if (!isConfirm) {\n      return;\n    }\n\n    //Show the loader on deleting theme.\n    const current_theme = jQuery(this);\n    current_theme.append('<span class=\"spinner is-active\"></span>');\n    let themeName = jQuery(this).attr('data-theme');\n    let themeType = jQuery(this).attr('data-theme-type').toLowerCase();\n    jQuery.ajax({\n      url: rmpObject.ajaxURL,\n      data: {\n        'action': 'rmp_theme_delete',\n        'ajax_nonce': rmpObject.ajax_nonce,\n        'theme_name': themeName,\n        'theme_type': themeType\n      },\n      type: 'POST',\n      dataType: 'json',\n      error: function (error) {\n        console.log(error.statusText);\n      },\n      success: function (response) {\n        current_theme.find('.spinner').removeClass('is-active');\n        if (response.success) {\n          location.reload();\n        } else {\n          alert(response.data.message);\n        }\n      }\n    });\n  });\n\n  /**\n   * Apply the selected theme in current active menu in editor.\n   *\n   * @version 4.0.0\n   *\n   * @fires click\n   */\n  jQuery(document).on('click', '.rmp-theme-apply', function (e) {\n    //Show the overlay with loader.\n    jQuery('.rmp-page-loader').css('display', 'flex');\n    jQuery.ajax({\n      url: rmpObject.ajaxURL,\n      data: {\n        'action': 'rmp_theme_apply',\n        'ajax_nonce': rmpObject.ajax_nonce,\n        'theme_name': jQuery(this).attr('theme-name'),\n        'theme_type': jQuery(this).attr('theme-type').toLowerCase(),\n        'menu_id': jQuery('#menu_id').val(),\n        'menu_to_use': jQuery('#rmp-menu-to-use').val()\n      },\n      type: 'POST',\n      dataType: 'json',\n      error: function (error) {\n        console.log(error.statusText);\n        jQuery('.rmp-page-loader').hide();\n      },\n      success: function (response) {\n        if (response.success) {\n          location.reload();\n        } else {\n          jQuery('.rmp-page-loader').hide();\n          alert(response.data.message);\n        }\n      }\n    });\n  });\n\n  /**\n   * Save the global settings on click.\n   *\n   * @version 4.0.0\n   *\n   * @fires click\n   */\n  jQuery('.rmp-save-global-settings-button').on('click', function (e) {\n    e.preventDefault();\n    jQuery.ajax({\n      url: rmpObject.ajaxURL,\n      data: {\n        'action': 'rmp_save_global_settings',\n        'ajax_nonce': rmpObject.ajax_nonce,\n        'form': jQuery('#rmp-global-settings').serialize()\n      },\n      type: 'POST',\n      dataType: 'json',\n      beforeSend: function () {\n        jQuery(this).prop('disabled', true);\n        jQuery('.spinner').addClass('is-active');\n      },\n      error: function (error) {\n        console.log('Internal Error !' + error);\n      },\n      success: function (response) {\n        jQuery('.spinner').removeClass('is-active');\n        jQuery(this).prop('disabled', false);\n      }\n    });\n  });\n\n  /**\n   * Initiate multiple selectize option of editor.\n   */\n  jQuery('#rmp-keyboard-shortcut-close-menu,#rmp-keyboard-shortcut-open-menu').selectize({\n    maxItems: 2,\n    plugins: ['remove_button']\n  });\n\n  /**\n   * Event to linked the group inputs.\n   *\n   * @fires Click\n   */\n  jQuery(document).on('click', 'button.rmp-group-input-linked', function () {\n    jQuery(this).toggleClass('is-linked');\n  });\n\n  /**\n   * Event to type on all sibblings input if linked.\n   *\n   * @fires keyup\n   */\n  jQuery(document).on('keyup', 'input.rmp-group-input', function (event) {\n    var pressedKeys = this.value.toLocaleLowerCase();\n    const parent = jQuery(this).parents('.rmp-input-group-control');\n    const isLinked = parent.find('.is-linked');\n    if (isLinked.length) {\n      parent.find('input.rmp-group-input').val(pressedKeys);\n    } else {\n      jQuery(this).val(pressedKeys);\n    }\n  });\n\n  /**\n   * Function to add the notification and update button.\n   */\n  function addUpdateNotification() {\n    if (!jQuery('#rmp-editor-main').find('#rmp-menu-update-notification').length) {\n      jQuery('#rmp-editor-main').prepend('<div id=\"rmp-menu-update-notification\" class=\"rmp-order-item rmp-order-item-description\">' + '<span> <span class=\"rmp-font-icon dashicons dashicons-warning \"></span> Update Required </span>' + '<a href=\"javascript:void(0)\" id=\"rmp-menu-quick-update-button\">UPDATE</a>' + '</div>');\n    }\n  }\n  jQuery('form#rmp-editor-form').on('keyup change paste', 'input, select, textarea, radio, checkbox', function () {\n    if (!jQuery(this).hasClass('no-updates')) {\n      addUpdateNotification();\n    }\n  });\n  jQuery(document).on('click', '#rmp-icon-dialog-select,.media-button-select,.rmp-icon-picker,.rmp-image-picker', function () {\n    if (!jQuery('#rmp-editor-main').find('#rmp-menu-update-notification').length) {\n      addUpdateNotification();\n    }\n  });\n\n  /**\n   * Event to download exported menu settings as json file.\n   *\n   * @version 4.0.0\n   */\n  jQuery('#rmp-export-menu-button').on('click', function (e) {\n    e.preventDefault();\n    let menu_id = jQuery('#rmp_export_menu_list').val();\n    jQuery.ajax({\n      url: rmpObject.ajaxURL,\n      data: {\n        'action': 'rmp_export_menu',\n        'ajax_nonce': rmpObject.ajax_nonce,\n        'menu_id': menu_id\n      },\n      type: 'POST',\n      dataType: 'json',\n      beforeSend: function () {\n        jQuery('#rmp-export-menu-button').prop('disabled', true);\n      },\n      error: function (error) {\n        console.log(error.statusText);\n        jQuery('#rmp-export-menu-button').prop('disabled', false);\n      },\n      success: function (response) {\n        jQuery('#rmp-export-menu-button').prop('disabled', false);\n        if (response.success) {\n          let menu_name = jQuery('#rmp_export_menu_list').children(\":selected\").text().trim().toLocaleLowerCase().split(' ').join('-');\n          download_file(response.data, menu_name + '.json', 'application/json');\n        } else {\n          jQuery('#rmp-global-settings').before('<div class=\"notice notice-error settings-error is-dismissible\"> <p>' + response.data.message + '</p></div>');\n          setTimeout(function () {\n            jQuery('#rmp-global-settings').parent().find('.notice').remove();\n          }, 3000);\n        }\n      }\n    });\n  });\n\n  /**\n   * Function to download the content as file.\n   *\n   * @since 4.0.0\n   *\n   * @param {String} content Contents for file\n   * @param {String} name    Name of the file.\n   * @param {String} type    File type\n   */\n  function download_file(content, name, type) {\n    const link = document.body.appendChild(document.createElement('a'));\n    const file = new Blob([content], {\n      type: type\n    });\n    link.href = URL.createObjectURL(file);\n    link.download = name;\n    link.click();\n  }\n\n  /**\n   * Event to download exported menu settings as json file.\n   *\n   * @version 4.0.0\n   */\n  jQuery('#rmp-import-menu-button').on('click', function (e) {\n    e.preventDefault();\n    let menu_id = jQuery('#rmp_import_menu_list').val();\n    if (!menu_id) {\n      alert('Please create menu first ! ');\n      return;\n    }\n    let file_data = jQuery('#rmp_input_import_file')[0].files[0];\n    if (!file_data) {\n      alert('Choose export file ! ');\n      return;\n    }\n    var form_data = new FormData();\n    form_data.append('file', file_data);\n    form_data.append('ajax_nonce', rmpObject.ajax_nonce);\n    form_data.append('menu_id', menu_id);\n    form_data.append('action', 'rmp_import_menu');\n    jQuery.ajax({\n      url: rmpObject.ajaxURL,\n      data: form_data,\n      type: 'POST',\n      cache: false,\n      contentType: false,\n      processData: false,\n      dataType: 'json',\n      beforeSend: function () {\n        jQuery('#rmp-import-menu-button').prop('disabled', true);\n      },\n      error: function (error) {\n        console.log(error.statusText);\n        jQuery('#rmp-import-menu-button').prop('disabled', false);\n      },\n      success: function (response) {\n        jQuery('#rmp-import-menu-button').prop('disabled', false);\n        let noticeClass = 'notice-error';\n        if (response.success) {\n          noticeClass = 'notice-success';\n          jQuery('#rmp_input_import_file').val('');\n        }\n        jQuery('#rmp-global-settings').before('<div class=\"notice ' + noticeClass + ' settings-error is-dismissible\"> <p>' + response.data.message + '</p></div>');\n        setTimeout(function () {\n          jQuery('#rmp-global-settings').parent().find('.notice').remove();\n        }, 3000);\n      }\n    });\n  });\n\n  /**\n   * Function to manage menu container animation options.\n   *\n   * @param {String} optionValue\n   */\n  function updateMenuContainerAnimationOptions(optionValue) {\n    if ('push' === optionValue) {\n      jQuery('#rmp-page-wrapper').parents('.rmp-input-control-wrapper').fadeIn();\n    } else {\n      jQuery('#rmp-page-wrapper').parents('.rmp-input-control-wrapper').fadeOut();\n    }\n    if ('fade' === optionValue) {\n      jQuery('#rmp-menu-appear-from option[value=\"top\"]').hide();\n      jQuery('#rmp-menu-appear-from option[value=\"bottom\"]').hide();\n    } else {\n      jQuery('#rmp-menu-appear-from option[value=\"top\"]').show();\n      jQuery('#rmp-menu-appear-from option[value=\"bottom\"]').show();\n    }\n  }\n\n  // Menu container animation type and their options.\n  updateMenuContainerAnimationOptions(jQuery('#rmp-animation-type').val());\n  jQuery('#rmp-editor-wrapper').on('change', '#rmp-animation-type', function (e) {\n    const optionValue = jQuery(this).val();\n    updateMenuContainerAnimationOptions(optionValue);\n  });\n\n  /**\n   * Event to back on home page under preview screen.\n   *\n   * @since 4.1.0\n   *\n   * @fires click\n   *\n   * @return void\n   */\n  jQuery('#rmp-preview-wrapper').on('click', () => {\n    let url = window.location.href;\n    url = url.substring(0, url.indexOf('wp-admin')) + '?rmp_preview_mode=true';\n    jQuery('#rmp-preview-iframe-loader').show();\n    jQuery('#rmp-preview-iframe').attr('src', url);\n  });\n\n  /** Call ajax to hide admin notice permanent. */\n  jQuery('.notice-responsive-menu').on('click', '.notice-dismiss', function (event) {\n    event.preventDefault();\n    jQuery.ajax({\n      type: \"POST\",\n      url: rmpObject.ajaxURL,\n      data: 'action=rmp_upgrade_admin_notice_dismiss'\n    });\n  });\n});\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/js/rmp-admin.js?")},"./assets/admin/js/rmp-editor.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * This file container the editor multi level features.\n *\n * @version 4.0.0\n *\n * @type {Object}\n */\nconst rmpEditor = {\n  editorSidebar: '#rmp-editor-wrapper',\n  sidebarDrawer: 'button.collapse-sidebar',\n  mainForm: '#rmp-editor-form',\n  editorContainer: '#rmp-editor-main',\n  topParentNav: '#rmp-editor-nav',\n  topParentTab: '#rmp-editor-pane',\n  childTabs: '.rmp-accordions',\n  parentTabItem: '.rmp-editor-pane-parent li.rmp-tab-item',\n  tabItem: 'li.rmp-tab-item',\n  quickItem: '.rmp-quick-edit-link',\n  tabItemTitle: '.rmp-tab-item-title',\n  titleLogo: '.rmp-editor-header-logo',\n  closeButton: '.rmp-editor-header-close',\n  searchButton: '.rmp-search-settings-btn',\n  searchForm: '.rmp-search-settings',\n  titleText: '.rmp-editor-header-title',\n  backButton: '.rmp-editor-header-back',\n  accordionItem: 'li.rmp-accordion-item',\n  tabId: null,\n  level: 0,\n  triggerBack: function () {\n    this.level--;\n    let parentId = jQuery('#' + this.tabId).attr('aria-parent');\n    jQuery('#' + parentId).show();\n    let title = jQuery('#' + parentId).attr('aria-label');\n    this.updateHeader(title);\n    jQuery('#' + this.tabId).hide();\n    this.tabId = parentId;\n  },\n  updatePanel: function (current) {\n    this.tabId = current.attr('aria-owns');\n    jQuery('#' + this.tabId).show();\n    let parentId = current.parent('ul').parent('div').attr('id');\n    jQuery('#' + this.tabId).attr('aria-parent', parentId);\n    jQuery('#' + parentId).hide();\n  },\n  updateQuickPanel: function (current) {\n    this.tabId = current.attr('aria-owns');\n    var accordionId = current.attr('accordion-id');\n    var subAccordionId = current.attr('sub-accordion-id');\n    var subTabId = current.attr('sub-tab-id');\n    let parentId = jQuery(\".rmp-accordions:visible\").attr('id');\n    jQuery('#' + this.tabId).attr('aria-parent', parentId);\n    jQuery('#' + parentId).hide();\n    jQuery('#' + this.tabId).show();\n    if (accordionId != '') {\n      if (!jQuery('#' + accordionId).hasClass(\"ui-state-active\")) {\n        jQuery('#' + accordionId).click();\n      }\n      if (subAccordionId != '') {\n        if (!jQuery('#' + subAccordionId).hasClass(\"ui-state-active\")) {\n          jQuery('#' + subAccordionId).click();\n        }\n        accordionId = subAccordionId;\n      }\n      setTimeout(function () {\n        var topPos = document.getElementById(accordionId).offsetTop;\n        jQuery('#rmp-editor-main').animate({\n          scrollTop: topPos - 60 + 'px'\n        }, 500);\n      }, 400);\n    }\n    if (subTabId != '') {\n      jQuery('#' + subTabId).click();\n    }\n  },\n  updateHeader: function (title) {\n    if (0 == this.level) {\n      jQuery(this.titleLogo).find('img').show();\n      jQuery(this.closeButton).show();\n      jQuery(this.backButton).hide();\n      jQuery(this.searchForm).css('width', '200');\n    } else if (1 == this.level) {\n      jQuery(this.backButton).css('display', 'flex');\n      jQuery(this.titleLogo).find('img').hide();\n      jQuery(this.closeButton).hide();\n      jQuery(this.searchForm).css('width', '255');\n    }\n    jQuery(this.titleText).text(title);\n  },\n  init: function () {\n    var self = this;\n\n    // Move on next panel when click on item.\n    jQuery(self.editorContainer).on('click', self.tabItem, function (e) {\n      e.stopPropagation();\n      e.preventDefault();\n      let current = jQuery(this);\n      self.level++;\n      self.updateHeader(current.text());\n      self.updatePanel(current);\n    });\n\n    // Move on next panel when click on item.\n    jQuery(self.editorContainer).on('click', self.quickItem, function (e) {\n      e.stopPropagation();\n      e.preventDefault();\n      let current = jQuery(this);\n      var tabId = current.attr('aria-owns');\n      var title = jQuery('.rmp-tab-item[aria-owns=\"' + tabId + '\"]').find('.rmp-tab-item-title').html();\n      self.level++;\n      self.updateHeader(title);\n      self.updateQuickPanel(current);\n    });\n\n    // Back from inner panel when click on back button.\n    jQuery(self.backButton).on('click', function (e) {\n      e.stopPropagation();\n      self.triggerBack();\n    });\n\n    // Open/Close the editor setting sidebar.\n    jQuery(self.sidebarDrawer).on('click', function (e) {\n      jQuery(self.editorSidebar).toggleClass('expanded collapsed');\n    });\n\n    // Open/Close the search form.\n    jQuery(self.searchButton).on('click', function (e) {\n      jQuery(self.searchForm).toggle();\n    });\n\n    //Search settings\n    jQuery.expr[':'].containsIgnoreCase = function (n, i, m) {\n      return jQuery(n).text().toUpperCase().indexOf(m[3].toUpperCase()) >= 0;\n    };\n    jQuery.fn.highlight = function (pat) {\n      function innerHighlight(node, pat) {\n        var skip = 0;\n        if (jQuery(node).is(\"select,input,textarea, .rmp-tooltip-content \")) {\n          return skip;\n        }\n        if (node.nodeType == 3) {\n          var pos = node.data.toUpperCase().indexOf(pat);\n          if (pos >= 0) {\n            var spannode = document.createElement('i');\n            spannode.className = 'rmp-highlight';\n            var middlebit = node.splitText(pos);\n            middlebit.splitText(pat.length);\n            var middleclone = middlebit.cloneNode(true);\n            spannode.appendChild(middleclone);\n            middlebit.parentNode.replaceChild(spannode, middlebit);\n            skip = 1;\n          }\n        } else if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {\n          for (var i = 0; i < node.childNodes.length; ++i) {\n            i += innerHighlight(node.childNodes[i], pat);\n          }\n        }\n        return skip;\n      }\n      return this.each(function () {\n        innerHighlight(this, pat.toUpperCase());\n      });\n    };\n    jQuery.fn.removeHighlight = function () {\n      function newNormalize(node) {\n        for (var i = 0, children = node.childNodes, nodeCount = children.length; i < nodeCount; i++) {\n          var child = children[i];\n          if (child.nodeType == 1) {\n            newNormalize(child);\n            continue;\n          }\n          if (child.nodeType != 3) {\n            continue;\n          }\n          var next = child.nextSibling;\n          if (next == null || next.nodeType != 3) {\n            continue;\n          }\n          var combined_text = child.nodeValue + next.nodeValue;\n          var new_node = node.ownerDocument.createTextNode(combined_text);\n          node.insertBefore(new_node, child);\n          node.removeChild(child);\n          node.removeChild(next);\n          i--;\n          nodeCount--;\n        }\n      }\n      return this.find(\"i.rmp-highlight\").each(function () {\n        var thisParent = this.parentNode;\n        thisParent.replaceChild(this.firstChild, this);\n        newNormalize(thisParent);\n      }).end();\n    };\n    jQuery(document).on('keyup change search', self.searchForm, function () {\n      var searchTerm = jQuery(this).val();\n      jQuery('#rmp-editor-main').removeHighlight();\n      jQuery('.rmp-search-results-found').remove();\n      if (searchTerm == '') return false;\n      jQuery('#rmp-editor-main').highlight(searchTerm);\n      jQuery(self.parentTabItem).each(function () {\n        var target = \"#\" + jQuery(this).attr(\"aria-owns\");\n        var count = jQuery(target).find(\"i.rmp-highlight:containsIgnoreCase(\" + searchTerm + \")\").length;\n        jQuery(target).find(self.tabItem).each(function () {\n          var childTarget = \"#\" + jQuery(this).attr(\"aria-owns\");\n          var childCount = jQuery(childTarget).find(\"i.rmp-highlight:containsIgnoreCase(\" + searchTerm + \")\").length;\n          if (childCount > 0) {\n            jQuery(this).append('<span class=\"rmp-search-results-found\">' + childCount + ' Results</span>');\n            count = Number(count) + Number(childCount);\n          }\n        });\n        if (count > 0) {\n          jQuery(target).find(self.accordionItem).each(function () {\n            var accordionItemCount = jQuery(this).find(\":not(.accordion-item-title, .item-title) > i.rmp-highlight:containsIgnoreCase(\" + searchTerm + \")\").length;\n            if (accordionItemCount > 0) {\n              jQuery(this).find('.rmp-accordion-title:first > .accordion-item-title, .rmp-accordion-title:first > .item-title').append('<span class=\"rmp-search-results-found\">' + accordionItemCount + ' Results</span>');\n            }\n          });\n          jQuery(this).append('<span class=\"rmp-search-results-found\">' + count + ' Results</span>');\n        }\n      });\n    });\n  }\n};\nrmpEditor.init();\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/js/rmp-editor.js?")},"./assets/admin/js/rmp-icon.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * This file contains the script to handle the icon wizard and its operations.\n *\n * @version 4.0.0\n */\njQuery(document).ready(function () {\n  var RMP_Icon = {\n    iconSelect: '#rmp-icon-dialog-select',\n    iconContainer: '.rmp-menu-icons-dialog',\n    clearSelector: '#rmp-icon-dialog-clear',\n    closeSelector: '.rmp-menu-icons-dialog .rmp-dialog-header button.close',\n    clear: function () {\n      var self = this;\n      jQuery(self.clearSelector).on('click', function () {\n        jQuery(self.iconContainer).find('input').prop('checked', false);\n      });\n    },\n    closeDialog: function () {\n      var self = this;\n      jQuery(self.closeSelector).on('click', function () {\n        jQuery(self.iconContainer).hide();\n      });\n    },\n    openDialog: function (iconChooser) {\n      var self = this;\n      jQuery(iconChooser).on('click', function (e) {\n        e.stopPropagation();\n        jQuery(self.iconContainer).show();\n        jQuery(self.iconSelect).attr('data-click', jQuery(e.target).attr('id'));\n      });\n    },\n    getIconElementWrap: function (icon_class) {\n      if (icon_class.includes('material-icons')) {\n        icon_class = icon_class.replace('material-icons', '');\n        return '<span class=\"rmp-font-icon material-icons\">' + icon_class + '</span>';\n      }\n      return '<span class=\"rmp-font-icon ' + icon_class + ' \"></span>';\n    },\n    removeIcon: function (iconChooser) {\n      jQuery(iconChooser).on('click', '.rmp-icon-picker-trash', function (e) {\n        e.preventDefault();\n        e.stopPropagation();\n        jQuery(this).parent('.rmp-icon-picker').siblings('input.rmp-icon-hidden-input').val('');\n        jQuery(this).siblings('.rmp-font-icon').remove();\n        jQuery(this).parent('.rmp-icon-picker').removeAttr('data-icon');\n        jQuery(this).remove();\n        if (!jQuery('#rmp-editor-main').find('#rmp-menu-update-notification').length) {\n          jQuery('#rmp-editor-main').prepend('<div id=\"rmp-menu-update-notification\" class=\"rmp-order-item rmp-order-item-description\">' + '<span> <span class=\"rmp-font-icon dashicons dashicons-warning \"></span> Update Required </span>' + '<a href=\"javascript:void(0)\" id=\"rmp-menu-quick-update-button\">UPDATE</a>' + '</div>');\n        }\n      });\n    },\n    getIcon: function () {\n      var self = this;\n      jQuery(document).on('click', this.iconSelect, function () {\n        let icon_class = jQuery(self.iconContainer).find('input:checked').val();\n        let clicker = '#' + jQuery(self.iconSelect).attr('data-click');\n        let icon_wrap = self.getIconElementWrap(icon_class);\n        jQuery(clicker).find('.rmp-font-icon').remove();\n        jQuery(clicker).prev('input.rmp-icon-hidden-input').val(icon_wrap);\n        jQuery(clicker).append(icon_wrap);\n        jQuery(clicker).attr('data-icon', true);\n        jQuery(clicker).find('.rmp-icon-picker-trash').remove();\n        jQuery(clicker).append('<i class=\"rmp-icon-picker-trash dashicons dashicons-trash\" aria-hidden=\"true\"></i>');\n        jQuery(self.iconSelect).removeAttr('data-click');\n        jQuery(self.closeSelector).click();\n        jQuery(clicker).prev('input').first().focus();\n      });\n    },\n    init: function (iconChooser) {\n      this.openDialog(iconChooser);\n      this.removeIcon(iconChooser);\n      this.getIcon();\n      this.clear();\n      this.closeDialog();\n      jQuery('#rmp-icon-search').on('keyup', _.debounce(this.searchIcon, 500));\n      jQuery('#rmp-icon-search').on('keyup', function () {\n        var query_string = this.value.toLocaleLowerCase();\n        if (query_string.length) {\n          if (!jQuery('#rmp-icon-search-typing-message').length) {\n            jQuery(this).after('<span id=\"rmp-icon-search-typing-message\"> Waiting for more keystrokes... </span>');\n          } else {\n            jQuery('#rmp-icon-search-typing-message').html('Waiting for more keystrokes...');\n            jQuery('#rmp-icon-search-typing-message').show();\n          }\n        }\n      });\n    },\n    searchIcon: function (e) {\n      jQuery('#rmp-icon-search-typing-message').html('Please wait moment..');\n      var query_string = this.value.toLocaleLowerCase();\n      var activeTab = jQuery('.rmp-menu-icons-dialog').find('.nav-tab-active');\n      if (!activeTab.length) {\n        activeTab = jQuery('.rmp-menu-icons-dialog').find('.nav-tab').first();\n      }\n      let icon_container = activeTab.attr('href');\n      var icon_selector = jQuery(icon_container + ' .font-icon');\n      var is_exist = false;\n      icon_selector.each(function () {\n        var icon_label = jQuery(this).children('input').val().toLocaleLowerCase();\n        if (icon_label.includes(query_string)) {\n          jQuery(this).show();\n          is_exist = true;\n        } else {\n          jQuery(this).hide();\n        }\n        if (is_exist) {\n          jQuery('#rmp-icon-search-typing-message').html('Done, Check results..');\n        } else {\n          jQuery('#rmp-icon-search-typing-message').html('Sorry, Not found..');\n        }\n      });\n    }\n  };\n  RMP_Icon.init('.rmp-icon-picker');\n});\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/js/rmp-icon.js?")},"./assets/admin/js/rmp-menu-wizard.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * This is js hook scripts file for responsive menu.\n *\n * @file   This files defines the rmpNewMenuWizard object.\n * @author ExpressTech System.\n *\n * @since 4.1.0\n *\n * @package responsive-menu\n */\n\n\n\n/**\n * Hooks class.\n *\n * @type  {Object}\n *\n * @since 4.1.0\n */\nconst rmpMenuWizard = {\n  /**\n   * Initialize.\n   *\n   * @return {void}\n   */\n  init() {\n    this.setProps();\n  },\n  /**\n   * Set properties and selectors.\n   *\n   * @return {void}\n   */\n  setProps() {\n    // Assign wizard container element id.\n    const menuWizardContainer = jQuery('#rmp-new-menu-wizard');\n\n    // Open new create menu wizard on click event.\n    jQuery(document).on('click', 'a.page-title-action', function (e) {\n      e.preventDefault();\n      menuWizardContainer.show();\n    });\n\n    // Close the new menu wizard.\n    jQuery('#rmp-new-menu-wizard .rmp-dialog-header button.close').on('click', function () {\n      menuWizardContainer.hide();\n    });\n\n    // Show/Hide the page selection input control.\n    menuWizardContainer.on('change', '.rmp-menu-display-option', function (e) {\n      const optionValue = jQuery(this).val();\n      if ('exclude-pages' === optionValue || 'include-pages' === optionValue) {\n        jQuery('#rmp-menu-page-selector').show();\n        return;\n      }\n      jQuery('#rmp-menu-page-selector').hide();\n    });\n\n    // Show/Hide change theme wizard in customizer page.\n    jQuery('.rmp-theme-change-button').on('click', function (e) {\n      menuWizardContainer.toggle();\n    });\n\n    // Multi step form event for next button.\n    jQuery('#rmp-menu-next-step').on('click', () => {\n      this.nextSection();\n    });\n\n    // Multi step form event for top item label.\n    jQuery('li.rmp-new-menu-step').on('click', e => {\n      const index = jQuery(e.currentTarget).index();\n      this.goToSection(index);\n    });\n\n    // Call ajax to save the new create menu.\n    jQuery('#rmp-create-new-menu').on('click', e => {\n      e.preventDefault();\n      const menuName = jQuery('#rmp-menu-name');\n      let themeName = jQuery('.rmp-theme-option:checked').val();\n      if (themeName == undefined) {\n        themeName = '';\n      }\n      jQuery.ajax({\n        url: rmpObject.ajaxURL,\n        data: {\n          'action': 'rmp_create_new_menu',\n          'ajax_nonce': rmpObject.ajax_nonce,\n          'menu_name': menuName.val(),\n          'menu_to_hide': jQuery('#rmp-hide-menu').val(),\n          'menu_to_use': jQuery('#rmp-menu-to-use').val(),\n          'menu_show_on_pages': jQuery('#rmp-menu-display-on-pages').val(),\n          'menu_show_on': jQuery('.rmp-menu-display-option').val(),\n          'menu_theme': themeName,\n          'theme_type': jQuery('.rmp-theme-option:checked').attr('theme-type')\n        },\n        type: 'POST',\n        dataType: 'json',\n        beforeSend: function () {\n          jQuery(e.currentTarget).prop('disabled', true);\n          jQuery('.spinner').addClass('is-active');\n        },\n        error: function (error) {\n          console.log('Internal Error !');\n          jQuery('#rmp-create-new-menu').prop('disabled', false);\n          jQuery('.spinner').removeClass('is-active');\n        },\n        success: function (response) {\n          jQuery('.spinner').removeClass('is-active');\n          jQuery('#rmp-create-new-menu').prop('disabled', false);\n          if (response.success) {\n            window.location.href = response.data.customize_url;\n          } else {\n            alert(response.data.message);\n          }\n        }\n      });\n    });\n\n    // Ajax call to upload the theme.\n    jQuery('#rmp-theme-upload').on('click', e => {\n      e.preventDefault();\n      let formData = new FormData();\n      let file = jQuery('#rmp_menu_theme_zip').prop('files')[0];\n      formData.append('file', file);\n      formData.append('action', 'rmp_menu_theme_upload');\n      formData.append('ajax_nonce', rmpObject.ajax_nonce);\n      jQuery.ajax({\n        url: rmpObject.ajaxURL,\n        data: formData,\n        type: 'POST',\n        processData: false,\n        contentType: false,\n        dataType: 'json',\n        success: response => {\n          jQuery('#rmp_menu_theme_zip').val('');\n          alert(response.data.message);\n          if (response.data.html) {\n            jQuery('#rmp-new-menu-wizard').find('#tabs-1').html(response.data.html);\n            jQuery('#rmp-menu-library-import').addClass('hide');\n          }\n        }\n      });\n    });\n\n    // Ajax call to check the recent changes the theme api.\n    jQuery('.rmp-call-theme-api-button').on('click', e => {\n      if (!jQuery(e.currentTarget).hasClass('rmp-call-theme-api-button')) {\n        return;\n      }\n      jQuery('#rmp-new-menu-wizard').find('.rmp-page-loader').css('display', 'flex');\n      jQuery.ajax({\n        url: rmpObject.ajaxURL,\n        data: {\n          'action': 'rmp_call_theme_api',\n          'ajax_nonce': rmpObject.ajax_nonce\n        },\n        type: 'POST',\n        dataType: 'json',\n        error: function (error) {\n          jQuery('#rmp-new-menu-wizard').find('.rmp-page-loader').hide();\n          jQuery('#rmp-new-menu-wizard').find('#tabs-2 .rmp_theme_grids').html('Internal Error !');\n        },\n        success: response => {\n          if (response.data.html) {\n            jQuery('#rmp-new-menu-wizard').find('#tabs-2 .rmp_theme_grids').html(response.data.html);\n            jQuery(e.currentTarget).removeClass('rmp-call-theme-api-button');\n          }\n        }\n      });\n    });\n  },\n  /**\n   * Jump to the next section of wizard.\n   *\n   * @return {void}\n   */\n  nextSection() {\n    var currectSectionIndex = jQuery('div.rmp-menu-section.current').index();\n    this.goToSection(currectSectionIndex + 1);\n  },\n  /**\n   * Show the indexed section in wizard.\n   *\n   * @return {void}\n   */\n  goToSection(currectSectionIndex) {\n    if (1 <= currectSectionIndex) {\n      jQuery('#rmp-create-new-menu').show();\n      jQuery('#rmp-menu-next-step').hide();\n    } else {\n      jQuery('#rmp-create-new-menu').hide();\n      jQuery('#rmp-menu-next-step').show();\n    }\n    jQuery('div.rmp-menu-section').eq(currectSectionIndex).addClass('current').siblings().removeClass('current');\n    jQuery('li.rmp-new-menu-step').eq(currectSectionIndex).addClass('current').siblings().removeClass('current');\n  }\n};\nrmpMenuWizard.init();\n/* harmony default export */ __webpack_exports__[\"default\"] = (rmpMenuWizard);\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/js/rmp-menu-wizard.js?")},"./assets/admin/js/rmp-preview.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * This is preview scripts file for responsive menu customizer.\n *\n * @file   This files defines the rmpHook object.\n * @author ExpressTech System.\n * @type  {Object}\n *\n * @since 4.0.0\n *\n * @package responsive-menu\n */\n\n/**\n * Hooks class.\n *\n * @type  {Object}\n *\n * @since 4.0.0\n */\nconst rmpHook = {\n  hooks: [],\n  isBreak: false,\n  /**\n   * Function to register the hook.\n   *\n   * @since 4.0.0\n   *\n   * @param String   name     Hook Name.\n   * @param function callback Associated function.\n   */\n  register: function (name, callback) {\n    if ('undefined' == typeof rmpHook.hooks[name]) {\n      rmpHook.hooks[name] = [];\n    }\n    rmpHook.hooks[name].push(callback);\n  },\n  /**\n   * Function to call the hook.\n   *\n   * @since 4.0.0\n   *\n   * @param String   name   Hook Name.\n   * @param function params Paramter list.\n   */\n  call: function (name, params) {\n    if ('undefined' != typeof rmpHook.hooks[name]) {\n      for (let i = 0; i < rmpHook.hooks[name].length; ++i) {\n        let output = rmpHook.hooks[name][i](params);\n        if (false == output) {\n          rmpHook.isBreak = true;\n          return false;\n        }\n        return output;\n      }\n    }\n    return true;\n  }\n};\n\n/**\n * Register function to color the menu elements.\n *\n * @since 4.0.0\n *\n * @param  {Object}  args List of inputs.\n * @return {String}\n */\nrmpHook.register('rmp_color_style', function (args) {\n  if (!args) {\n    return false;\n  }\n\n  // Set the state/pseudo class.\n  if ('hover' == args.state) {\n    args.outputSelector = args.outputSelector + ':hover';\n  } else if ('placeholder' == args.state) {\n    args.outputSelector = args.outputSelector + '::placeholder';\n  } else if ('before' == args.state) {\n    args.outputSelector = args.outputSelector + '::before';\n  } else if ('after' == args.state) {\n    args.outputSelector = args.outputSelector + '::after';\n  }\n\n  //Prepare css string and return.\n  return args.outputSelector + '{ ' + args.attr + ' : ' + args.value + ';}';\n});\n\n/**\n * rmpPreview class\n *\n * @since 4.0.0\n *\n * @type  {Object}\n */\nwindow.RMP_Preview = {\n  iframe: '#rmp-preview-iframe',\n  menuId: jQuery('#menu_id').val(),\n  mobile_breakpoint: jQuery('#rmp-menu-mobile-breakpoint').val() + 'px',\n  tablet_breakpoint: jQuery('#rmp-menu-tablet-breakpoint').val() + 'px',\n  active_device: jQuery('#rmp_device_mode'),\n  menuContainer: '#rmp-container-' + self.menuId,\n  onTyping: function (inputSelector, outputSelector, type) {\n    let meta = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';\n    var self = this;\n    var iframe = jQuery(self.iframe);\n    jQuery(inputSelector).on('keyup change paste', function () {\n      let value = jQuery(this).val();\n      let is_linked = jQuery(this).parents('.rmp-input-group-control').find('.rmp-group-input-linked').hasClass('is-linked');\n      let pos = jQuery(this).attr('data-input');\n      let attr = '';\n      let unit = '';\n      let css = '';\n      switch (type) {\n        case 'border-radius':\n          css = outputSelector + '{ border-radius : ' + value + 'px;}';\n          self.inlineCssInjector(css);\n          break;\n        case 'section-padding':\n          attr = 'padding';\n          if (!is_linked) {\n            attr = attr + '-' + pos;\n          }\n          css = outputSelector + '{ ' + attr + ' : ' + value + ';}';\n          self.inlineCssInjector(css);\n          break;\n        case 'trigger-text':\n          if (iframe.contents().find(outputSelector).length) {\n            iframe.contents().find(outputSelector).html(this.value);\n          } else {\n            iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box').before('<div class=\"rmp-trigger-label rmp-trigger-label-top\"><span class=\"rmp-trigger-text\">\"' + this.value + '\"</span></div>');\n          }\n          break;\n        case 'trigger-text-open':\n          if (iframe.contents().find(outputSelector).length) {\n            iframe.contents().find(outputSelector).html(this.value);\n          } else {\n            iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box').before('<div class=\"rmp-trigger-label rmp-trigger-label-top\"><span class=\"rmp-trigger-text-open\">\"' + this.value + '\"</span></div>');\n          }\n          break;\n        case 'text':\n          iframe.contents().find(outputSelector).html(this.value);\n          break;\n        case 'placeholder':\n          iframe.contents().find(outputSelector).attr('placeholder', this.value);\n          break;\n        case 'href':\n          iframe.contents().find(outputSelector).attr('href', this.value);\n          break;\n        case 'font-size':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit.length) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ font-size : ' + (value + unit) + ';}';\n          if (jQuery(this).attr('multi-device')) {\n            css = self.mediaQuery(css);\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'width':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ width : ' + (this.value + unit) + ';}';\n          self.inlineCssInjector(css);\n          break;\n        case 'height':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit.length) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ height : ' + (this.value + unit) + ';}';\n          if (jQuery(this).attr('multi-device')) {\n            css = self.mediaQuery(css);\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'line-height':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit.length) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ line-height : ' + (this.value + unit) + ';}';\n          if (jQuery(this).attr('multi-device')) {\n            css = self.mediaQuery(css);\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'min-width':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit.length) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ min-width : ' + (this.value + unit) + ';}';\n          self.inlineCssInjector(css);\n          break;\n        case 'max-width':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit.length) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ max-width : ' + (this.value + unit) + ';}';\n          self.inlineCssInjector(css);\n          break;\n        case 'trigger-side-position':\n          var side = jQuery('#rmp-menu-button-left-or-right').val();\n          unit = jQuery('#rmp-menu-button-distance-from-side-unit').val();\n          css = outputSelector + '{ ' + side + ' :' + (value + unit) + ' !important;}';\n          self.inlineCssInjector(css);\n          break;\n        case 'top':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ top :' + (value + unit) + ' !important;}';\n          self.inlineCssInjector(css);\n          break;\n        case 'bottom':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ bottom :' + (value + unit) + ' !important;}';\n          self.inlineCssInjector(css);\n          break;\n        case 'border-width':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit) {\n            unit = 'px';\n          }\n          css = outputSelector + '{ border-width : ' + (this.value + unit) + ';}';\n          self.inlineCssInjector(css);\n          break;\n        case 'padding':\n          unit = jQuery(this).next('.is-unit').val();\n          if (!unit) {\n            unit = 'px';\n          }\n          if (meta == 'lr') {\n            css = outputSelector + '{ padding : 0 ' + (this.value + unit) + ';}';\n          }\n          self.inlineCssInjector(css);\n          break;\n      }\n    });\n  },\n  bindImage: function (inputSelector, outputSelector, type) {\n    var self = this;\n    var iframe = jQuery(self.iframe);\n    jQuery(document).on('click', inputSelector, function (e) {\n      e.preventDefault();\n      var button = jQuery(this),\n        custom_uploader = wp.media({\n          title: 'Select image',\n          library: {\n            type: 'image'\n          },\n          button: {\n            text: 'Use this image'\n          },\n          multiple: false\n        }).on('select', function () {\n          var attachment = custom_uploader.state().get('selection').first().toJSON();\n          jQuery(e.target).prev('input.rmp-image-url-input').val(attachment.url);\n          jQuery(e.target).css('background-image', 'url(' + attachment.url + ')');\n          jQuery(e.target).append('<i class=\"rmp-image-picker-trash dashicons dashicons-trash\" aria-hidden=\"true\"></i>');\n          if (type == 'img-src') {\n            iframe.contents().find(outputSelector).attr('src', attachment.url);\n          } else if (type == 'background') {\n            let css = outputSelector + '{ background-image : url(' + attachment.url + ');}';\n            self.inlineCssInjector(css);\n          } else if (type == 'trigger-icon') {\n            if (iframe.contents().find(outputSelector).length) {\n              iframe.contents().find(outputSelector).attr('src', attachment.url);\n            } else {\n              iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .responsive-menu-pro-inner').hide();\n              iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box').append('<img class=\"rmp-trigger-icon rmp-trigger-icon-inactive\" src=\"' + attachment.url + '\"/>');\n            }\n          } else if (type == 'trigger-icon-open') {\n            if (iframe.contents().find(outputSelector).length) {\n              iframe.contents().find(outputSelector).attr('src', attachment.url);\n            } else {\n              iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .responsive-menu-pro-inner').hide();\n              iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box').append('<img class=\"rmp-trigger-icon rmp-trigger-icon-active\" src=\"' + attachment.url + '\"/>');\n            }\n          }\n        }).open();\n    });\n  },\n  toggleElements: function (inputSelector, outputSelector) {\n    var self = this;\n    jQuery(inputSelector).on('change', function (e) {\n      e.preventDefault();\n      e.stopPropagation();\n      var iframe = jQuery(self.iframe);\n      if (iframe.contents().find(outputSelector).length) {\n        if (jQuery(this).is(':checked')) {\n          iframe.contents().find(outputSelector).fadeIn(500);\n        } else {\n          iframe.contents().find(outputSelector).fadeOut(500);\n        }\n      } else {\n        e.preventDefault();\n        var menuId = jQuery('#menu_id').val(),\n          toggle_on = jQuery(this).data('toggle');\n        jQuery.ajax({\n          url: rmpObject.ajaxURL,\n          data: {\n            'action': 'rmp_enable_menu_item',\n            'ajax_nonce': rmpObject.ajax_nonce,\n            'menu_id': menuId,\n            'menu_element': toggle_on\n          },\n          type: 'POST',\n          dataType: 'json',\n          beforeSend: function () {\n            jQuery(this).prop('disabled', true);\n            jQuery('#iframe-spinner').show();\n          },\n          error: function (error) {\n            console.log('Internal Error !');\n            jQuery(this).prop('disabled', false);\n            jQuery('#iframe-spinner').hide();\n          },\n          success: function (response) {\n            if (response.data.markup) {\n              iframe.contents().find('#rmp-container-' + self.menuId).append(response.data.markup);\n              self.orderMenuElements();\n            }\n            jQuery(this).prop('disabled', false);\n            jQuery('#iframe-spinner').hide();\n          }\n        });\n      }\n    });\n  },\n  orderMenuElements: function () {\n    var list = [];\n    var self = this;\n    var iframeContents = jQuery(self.iframe).contents();\n    jQuery('#tab-container .item-title').each(function () {\n      var val = jQuery(this).text().toLocaleLowerCase().trim();\n      if (val == 'title') {\n        list.push(iframeContents.find(self.menuTitle));\n        iframeContents.find(self.menuTitle).remove();\n      } else if (val == 'search') {\n        list.push(iframeContents.find(self.menuSearch));\n        iframeContents.find(self.menuSearch).remove();\n      } else if (val == 'menu') {\n        list.push(iframeContents.find(self.menuWrap));\n        iframeContents.find(self.menuWrap).remove();\n      } else {\n        list.push(iframeContents.find(self.menuContents));\n        iframeContents.find(self.menuContents).remove();\n      }\n    });\n    list.forEach(function (menuElement) {\n      iframeContents.find(self.menuContainer).append(menuElement);\n    });\n  },\n  /**\n   * Function to bind the color input with option and elements.\n   *\n   * @version 4.0.0\n   *\n   * @param {String} inputSelector\n   * @param {String} outputSelector\n   * @param {String} attr\n   * @param {String} state\n   */\n  bindColor: function (inputSelector, outputSelector, attr, state) {\n    var self = this;\n    jQuery(inputSelector).wpColorPicker({\n      change: function (event, ui) {\n        var value = ui.color.toString();\n        var css = rmpHook.call('rmp_color_style', {\n          'outputSelector': outputSelector,\n          'attr': attr,\n          'value': value,\n          'state': state\n        });\n        if (jQuery(inputSelector).attr('multi-device')) {\n          css = self.mediaQuery(css);\n        }\n        self.inlineCssInjector(css);\n      }\n    });\n  },\n  mediaQuery: function (css) {\n    var self = this;\n    self.tablet_breakpoint = jQuery('#rmp-menu-tablet-breakpoint').val() + 'px';\n    css = '@media screen and (max-width: ' + self.tablet_breakpoint + ' ) {' + css + '}';\n    return css;\n  },\n  inlineCssInjector: function (css) {\n    var self = this;\n    var iframe = jQuery(self.iframe);\n    var styleElement = iframe.contents().find('#rmp-inline-css-' + self.menuId);\n    if (styleElement.length) {\n      styleElement.append(css);\n    } else {\n      let style = '<style id=\"rmp-inline-css-' + self.menuId + '\">' + css + '</style>';\n      iframe.contents().find('head').append(style);\n    }\n  },\n  changeInput: function (inputSelector, outputSelector, attr) {\n    let meta = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';\n    var self = this;\n    var iframe = jQuery(self.iframe);\n    jQuery(inputSelector).on('change', function (e) {\n      let value = jQuery(this).val();\n      let unit = jQuery(this).next('.is-unit').val() || 'px'; // Assign default unit if not specified\n      let css = '';\n      let side = '';\n      switch (attr) {\n        case 'height-unit':\n          css = outputSelector + '{ height : ' + (value + unit) + ';}';\n          if (jQuery(this).attr('multi-device')) {\n            css = self.mediaQuery(css);\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'line-height-unit':\n          css = outputSelector + '{ line-height : ' + (value + unit) + ';}';\n          if (jQuery(this).attr('multi-device')) {\n            css = self.mediaQuery(css);\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'width-unit':\n          css = outputSelector + '{ width : ' + (value + unit) + ';}';\n          self.inlineCssInjector(css);\n          break;\n        case 'font-size':\n          css = outputSelector + '{ font-size :' + value + unit + ' !important;}';\n          if (jQuery(this).attr('multi-device')) {\n            css = self.mediaQuery(css);\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'font-family':\n          css = outputSelector + '{ font-family :' + value + ' !important;}';\n          if (jQuery(this).attr('multi-device')) {\n            css = self.mediaQuery(css);\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'font-weight':\n          css = outputSelector + '{ font-weight :' + value + ';}';\n          self.inlineCssInjector(css);\n          break;\n        case 'padding-unit':\n          if (!unit) {\n            unit = 'px';\n          }\n          if (meta == 'lr') {\n            css = outputSelector + '{ padding : 0 ' + (value + unit) + ';}';\n          }\n          self.inlineCssInjector(css);\n          break;\n        case 'letter-spacing':\n          css = outputSelector + '{ letter-spacing :' + value + 'px; }';\n          self.inlineCssInjector(css);\n          break;\n        case 'position-alignment':\n          if (iframe.contents().find(outputSelector).length) {\n            let position = jQuery(this).val();\n            var rmpTriggerBox = iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box');\n            iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box').remove();\n            if (position == 'top' || position == 'left') {\n              iframe.contents().find('#rmp_menu_trigger-' + self.menuId).append(rmpTriggerBox);\n            } else {\n              iframe.contents().find('#rmp_menu_trigger-' + self.menuId).prepend(rmpTriggerBox);\n            }\n          }\n          break;\n        case 'trigger-animation':\n          var new_class = 'rmp-menu-trigger-' + value;\n          let all_class = iframe.contents().find(outputSelector).attr('class').split(\" \");\n          all_class.forEach(function (value) {\n            if (value.includes('rmp-menu-trigger-')) {\n              iframe.contents().find(outputSelector).removeClass(value);\n              iframe.contents().find(outputSelector).addClass(new_class);\n            }\n          });\n          break;\n        case 'top':\n          css = outputSelector + '{ top :' + (value + unit) + ' !important;}';\n          self.inlineCssInjector(css);\n          break;\n        case 'trigger-side-position':\n          side = jQuery('#rmp-menu-button-left-or-right').val();\n          css = outputSelector + '{ ' + side + ' :' + (value + unit) + ' !important;}';\n          self.inlineCssInjector(css);\n          break;\n        case 'trigger-side':\n          side = jQuery(this).val();\n          css = outputSelector + '{' + side + ':' + (value + unit) + ' !important;' + (side === 'left' ? 'right:unset !important;' : 'left:unset !important;') + '}';\n          self.inlineCssInjector(css);\n          break;\n        case 'position':\n          css = outputSelector + '{ position :' + value + ' !important;}';\n          self.inlineCssInjector(css);\n          break;\n        case 'trigger-background':\n          if (jQuery(this).is(':checked')) {\n            iframe.contents().find(outputSelector).attr('style', 'background:unset !important;');\n          } else {\n            iframe.contents().find(outputSelector).removeAttr('style');\n          }\n          break;\n        case 'target':\n          let targetValue = jQuery(this).val();\n          if (!targetValue.length) {\n            targetValue = '_self';\n          }\n          iframe.contents().find(outputSelector).attr('target', targetValue);\n          break;\n        case 'text-align':\n          let textAlignValue = jQuery(this).val();\n          iframe.contents().find(outputSelector).css({\n            'text-align': textAlignValue\n          });\n          break;\n      }\n    });\n  },\n  init: function () {\n    var self = this;\n\n    //Mobile menu elements.\n    self.menuContainer = '#rmp-container-' + self.menuId;\n    self.menuTitle = '#rmp-menu-title-' + self.menuId;\n    self.menuSearch = '#rmp-search-box-' + self.menuId;\n    self.menuWrap = '#rmp-menu-wrap-' + self.menuId;\n    self.menuContents = '#rmp-menu-additional-content-' + self.menuId;\n\n    //Menu container background color.\n    self.bindColor('#rmp-container-background-colour', '#rmp-container-' + self.menuId, 'background', '');\n\n    //Menu background.\n    self.bindColor('#rmp-menu-background-colour', '#rmp-menu-wrap-' + self.menuId, 'background');\n\n    //Menu title section background color.\n    self.bindColor('#rmp-menu-title-background-colour', '#rmp-menu-title-' + self.menuId, 'background');\n\n    //Menu title section background hover color.\n    self.bindColor('#rmp-menu-title-background-hover-colour', '#rmp-menu-title-' + self.menuId, 'background', 'hover');\n\n    // Menu item trigger\n\n    self.bindColor('#rmp-menu-sub-arrow-shape-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'color');\n    self.bindColor('#rmp-menu-sub-arrow-shape-hover-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'color', 'hover');\n    self.bindColor('#rmp-menu-sub-arrow-shape-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow.rmp-menu-subarrow-active', 'color');\n    self.bindColor('#rmp-menu-sub-arrow-shape-hover-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow.rmp-menu-subarrow-active', 'color', 'hover');\n    self.bindColor('#rmp-menu-sub-arrow-border-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'border-color');\n    self.bindColor('#rmp-menu-sub-arrow-border-hover-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'border-color', 'hover');\n    self.bindColor('#rmp-menu-sub-arrow-border-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow-active', 'border-color');\n    self.bindColor('#rmp-menu-sub-arrow-border-hover-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow-active', 'border-color', 'hover');\n    self.bindColor('#rmp-menu-sub-arrow-background-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'background');\n    self.bindColor('#rmp-menu-sub-arrow-background-hover-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'background', 'hover');\n    self.bindColor('#rmp-menu-sub-arrow-background-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow.rmp-menu-subarrow-active', 'background');\n    self.bindColor('#rmp-menu-sub-arrow-background-hover-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow.rmp-menu-subarrow-active', 'background', 'hover');\n\n    //Legacy options\n    self.bindColor('#rmp-submenu-sub-arrow-shape-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'color');\n    self.bindColor('#rmp-submenu-sub-arrow-shape-colour-hover', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'color', 'hover');\n    self.bindColor('#rmp-submenu-sub-arrow-shape-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow-active', 'color');\n    self.bindColor('#rmp-submenu-sub-arrow-shape-hover-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow-active', 'color', 'hover');\n    self.bindColor('#rmp-submenu-sub-arrow-border-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'border-color');\n    self.bindColor('#rmp-submenu-sub-arrow-border-hover-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'border-color', 'hover');\n    self.bindColor('#rmp-submenu-sub-arrow-border-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow.rmp-menu-subarrow-active', 'border-color');\n    self.bindColor('#rmp-submenu-sub-arrow-border-hover-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow-active', 'border-color', 'hover');\n    self.bindColor('#rmp-submenu-sub-arrow-background-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'background');\n    self.bindColor('#rmp-submenu-sub-arrow-background-hover-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'background', 'hover');\n    self.bindColor('#rmp-submenu-sub-arrow-background-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow-active', 'background');\n    self.bindColor('#rmp-submenu-sub-arrow-background-hover-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow-active', 'background', 'hover');\n    self.bindColor('#rmp-menu-title-colour', '#rmp-menu-title-' + self.menuId + ' > span', 'color');\n    self.bindColor('#rmp-menu-title-hover-colour', '#rmp-menu-title-' + self.menuId + ' > span', 'color', 'hover');\n    self.bindColor('#rmp-menu-additional-content-color', '#rmp-container-' + self.menuId + ' #rmp-menu-additional-content-' + self.menuId, 'color');\n    self.bindColor('#rmp-menu-search-box-text-colour', '#rmp-container-' + self.menuId + ' #rmp-search-box-' + self.menuId + ' .rmp-search-box', 'color');\n    self.bindColor('#rmp-menu-search-box-background-colour', '#rmp-search-box-' + self.menuId + ' .rmp-search-box', 'background');\n    self.bindColor('#rmp-menu-search-box-border-colour', '#rmp-search-box-' + self.menuId + ' .rmp-search-box', 'border-color');\n    self.bindColor('#rmp-menu-search-box-placeholder-colour', '#rmp-search-box-' + self.menuId + ' .rmp-search-box', 'color', 'placeholder');\n    self.changeInput('#rmp-menu-title-font-weight', '#rmp-menu-title-' + self.menuId + ' #rmp-menu-title-link', 'font-weight');\n    self.changeInput('#rmp-menu-title-font-family', '#rmp-menu-title-' + self.menuId + ' #rmp-menu-title-link', 'font-family');\n\n    //Menu Trigger\n    self.bindColor('#rmp-menu-button-background-colour', '#rmp_menu_trigger-' + self.menuId, 'background', '');\n    self.bindColor('#rmp-menu-button-background-colour-hover', '#rmp_menu_trigger-' + self.menuId, 'background-color', 'hover');\n    self.bindColor('#rmp-menu-button-background-colour-active', '#rmp_menu_trigger-' + self.menuId + '.is-active', 'background', '');\n    self.bindColor('#rmp-menu-button-line-colour', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner,#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:after,#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:before', 'background', '');\n    self.bindColor('#rmp-menu-button-line-colour-active', '.is-active#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner,.is-active#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:after,.is-active#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:before', 'background', '');\n    self.bindColor('#rmp-menu-button-line-colour-hover', '#rmp_menu_trigger-' + self.menuId + ':hover .responsive-menu-pro-inner,#rmp_menu_trigger-' + self.menuId + ':hover .responsive-menu-pro-inner:after,#rmp_menu_trigger-' + self.menuId + ':hover .responsive-menu-pro-inner:before', 'background', '');\n    self.bindColor('#rmp-menu-button-text-colour', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-label', 'color');\n    self.onTyping('#rmp-menu-toggle-border-radius', '#rmp_menu_trigger-' + self.menuId, 'border-radius');\n    self.bindColor('#rmp-menu-button-line-colour', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .rmp-trigger-icon-inactive .rmp-font-icon', 'color', '');\n    self.bindColor('#rmp-menu-button-line-colour-active', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .rmp-trigger-icon-active .rmp-font-icon', 'color', '');\n    self.bindColor('#rmp-menu-button-line-colour-hover', '#rmp_menu_trigger-' + self.menuId + ':hover .rmp-trigger-box .rmp-trigger-icon-inactive .rmp-font-icon', 'color', '');\n    self.onTyping('.rmp-menu-container-padding', '#rmp-container-' + self.menuId, 'section-padding');\n    self.onTyping('.rmp-menu-title-section-padding', '#rmp-menu-title-' + self.menuId, 'section-padding');\n    self.onTyping('.rmp-menu-section-padding', '#rmp-menu-wrap-' + self.menuId, 'section-padding');\n    self.onTyping('.rmp-menu-search-section-padding', '#rmp-search-box-' + self.menuId, 'section-padding');\n    self.onTyping('.rmp-menu-additional-section-padding', '#rmp-menu-additional-content-' + self.menuId, 'section-padding');\n\n    // CONTENT BASED ELEMENTS.\n\n    self.onTyping('#rmp-menu-search-box-height', '#rmp-search-box-' + self.menuId + ' .rmp-search-box', 'height');\n    self.onTyping('#rmp-menu-search-box-border-radius', '#rmp-search-box-' + self.menuId + ' .rmp-search-box', 'border-radius');\n    self.onTyping('#rmp-menu-menu-title', '#rmp-menu-title-' + self.menuId + ' .rmp-menu-title-link span', 'text');\n    self.onTyping('#rmp-menu-additional-content', '#rmp-menu-additional-content-' + self.menuId, 'text');\n    self.onTyping('#rmp-menu-search-box-text', '#rmp-search-box-' + self.menuId + ' .rmp-search-box', 'placeholder');\n    self.onTyping('#rmp-menu-title-image-alt', '#rmp-menu-title-' + self.menuId + ' .rmp-menu-title-image', 'alt');\n    self.onTyping('#rmp-menu-title-font-size', '#rmp-menu-title-' + self.menuId + ' > a', 'font-size');\n    self.onTyping('#rmp-menu-title-image-width', '#rmp-menu-title-' + self.menuId + ' .rmp-menu-title-image', 'width');\n    self.onTyping('#rmp-menu-title-image-height', '#rmp-menu-title-' + self.menuId + ' .rmp-menu-title-image', 'height');\n    self.bindImage('#rmp-menu-title-image-selector', '#rmp-menu-title-' + self.menuId + ' .rmp-menu-title-image', 'img-src');\n    self.onTyping('#rmp-menu-additional-content-font-size', '#rmp-menu-additional-content-' + self.menuId, 'font-size');\n    self.onTyping('#rmp-menu-container-width', '#rmp-container-' + self.menuId, 'width');\n    self.onTyping('#rmp-menu-container-min-width', '#rmp-container-' + self.menuId, 'min-width');\n    self.onTyping('#rmp-menu-container-max-width', '#rmp-container-' + self.menuId, 'max-width');\n    self.onTyping('#rmp-menu-button-image-alt-when-clicked', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-icon-active', 'alt');\n    self.onTyping('#rmp-menu-button-image-alt', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-icon-inactive', 'alt');\n    self.onTyping('#rmp-menu-button-title-open', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-text-open', 'trigger-text-open');\n    self.onTyping('#rmp-menu-button-title', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-text', 'trigger-text');\n    self.onTyping('#rmp-menu-button-font-size', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-label', 'font-size');\n    self.onTyping('#rmp-menu-button-title-line-height', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-label', 'line-height');\n\n    //Menu Trigger\n    self.onTyping('#rmp-menu-button-width', '#rmp_menu_trigger-' + self.menuId, 'width');\n    self.onTyping('#rmp-menu-button-height', '#rmp_menu_trigger-' + self.menuId, 'height');\n    self.onTyping('#rmp-menu-button-line-width', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner', 'width');\n    self.onTyping('#rmp-menu-button-line-width', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:after', 'width');\n    self.onTyping('#rmp-menu-button-line-width', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:before', 'width');\n    self.onTyping('#rmp-menu-button-line-height', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner', 'height');\n    self.onTyping('#rmp-menu-button-line-margin', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:after', 'bottom');\n    self.onTyping('#rmp-menu-button-line-margin', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:before', 'top');\n    self.onTyping('#rmp-menu-button-line-height', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:after', 'height');\n    self.onTyping('#rmp-menu-button-line-height', '#rmp_menu_trigger-' + self.menuId + ' .responsive-menu-pro-inner:before', 'height');\n    self.bindImage('#rmp-button-title-image', '#rmp-menu-title-' + self.menuId + ' .rmp-menu-title-image', 'img-src');\n    self.bindImage('#rmp-menu-background-image-selector', '#rmp-container-' + self.menuId, 'background');\n    self.bindImage('#rmp-menu-button-image-when-clicked-selector', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-icon-active', 'trigger-icon-open');\n    self.bindImage('#rmp-menu-button-image-selector', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-icon-inactive', 'trigger-icon');\n    self.changeInput('#rmp-menu-title-link-location', '#rmp-menu-title-' + self.menuId + ' #rmp-menu-title-link', 'target');\n    self.changeInput('.rmp-menu-title-alignment', '#rmp-menu-title-' + self.menuId, 'text-align');\n    self.changeInput('.rmp-menu-additional-content-alignment', '#rmp-menu-additional-content-' + self.menuId, 'text-align');\n\n    //Top menu item links\n    self.onTyping('#rmp-menu-links-height', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'height');\n    self.onTyping('#rmp-menu-links-line-height', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'line-height');\n    self.onTyping('#rmp-menu-font-size', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'font-size');\n    self.changeInput('#rmp-menu-font', '#rmp-container-' + self.menuId + ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-item-link', 'font-family');\n    self.changeInput('#rmp-menu-font-weight', '#rmp-container-' + self.menuId + ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-item-link', 'font-weight');\n    self.changeInput('.rmp-menu-text-alignment', '#rmp-container-' + self.menuId + ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-item-link', 'text-align');\n    self.changeInput('#rmp-menu-text-letter-spacing', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'letter-spacing');\n    self.onTyping('#rmp-menu-depth-level-0', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'padding', 'lr');\n    self.onTyping('#rmp-menu-border-width', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'border-width');\n    self.onTyping('#rmp-menu-sub-arrow-border-width', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'border-width');\n    self.onTyping('#rmp-submenu-sub-arrow-border-width', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'border-width');\n    self.bindColor('#rmp-menu-link-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'color');\n    self.bindColor('#rmp-menu-link-hover-color', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'color', 'hover');\n    self.bindColor('#rmp-menu-current-link-active-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-current-item .rmp-menu-item-link', 'color');\n    self.bindColor('#rmp-menu-current-link-active-hover-color', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-current-item .rmp-menu-item-link', 'color', 'hover');\n    self.bindColor('#rmp-menu-item-background-colour', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'background');\n    self.bindColor('#rmp-menu-item-background-hover-color', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'background', 'hover');\n    self.bindColor('#rmp-menu-current-item-background-color', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-current-item .rmp-menu-item-link', 'background');\n    self.bindColor('#rmp-menu-current-item-background-hover-color', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-current-item .rmp-menu-item-link', 'background', 'hover');\n    self.bindColor('#rmp-menu-item-border-colour', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'border-color');\n    self.bindColor('#rmp-menu-item-border-colour-hover', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-item-link', 'border-color', 'hover');\n    self.bindColor('#rmp-menu-current-item-border-hover-colour', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-current-item .rmp-menu-item-link', 'border-color', 'hover');\n    self.bindColor('#rmp-menu-item-border-colour-active', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-current-item .rmp-menu-item-link', 'border-color');\n\n    // Trigger of top level\n    self.bindImage('#rmp-menu-inactive-arrow-image-selector', '#rmp-container-' + self.menuId + ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-subarrow', 'background');\n    self.bindImage('#rmp-menu-active-arrow-image-selector', '#rmp-container-' + self.menuId + ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-subarrow-active', 'background');\n    self.onTyping('#rmp-submenu-arrow-height', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'height');\n    self.onTyping('#rmp-submenu-arrow-width', '#rmp-menu-wrap-' + self.menuId + ' .rmp-menu-subarrow', 'width');\n    self.onTyping('#rmp-submenu-child-arrow-height', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'height');\n    self.onTyping('#rmp-submenu-child-arrow-width', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'width');\n    self.changeInput('#rmp-submenu-child-arrow-width-unit', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'width-unit');\n    self.changeInput('#rmp-submenu-child-arrow-height-unit', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-subarrow', 'height-unit');\n    self.bindColor('#rmp-menu-sub-arrow-background-color', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-subarrow', 'background');\n    self.bindColor('#rmp-menu-sub-arrow-background-hover-colour', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-subarrow', 'background', 'hover');\n    self.bindColor('#rmp-menu-sub-arrow-background-colour-active', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-subarrow-active', 'background');\n    self.bindColor('#rmp-menu-sub-arrow-background-hover-colour-active', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-menu-top-level-item .rmp-menu-subarrow-active', 'background', 'hover');\n\n    //sub menu item links\n    self.onTyping('#rmp-submenu-links-height', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'height');\n    self.changeInput('#rmp-submenu-links-height-unit', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'height-unit');\n    self.onTyping('#rmp-submenu-links-line-height', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'line-height');\n    self.changeInput('#rmp-submenu-links-line-height-unit', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'line-height-unit');\n    self.onTyping('#rmp-submenu-font-size', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'font-size');\n    self.changeInput('#rmp-submenu-font', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'font-family');\n    self.changeInput('#rmp-submenu-font-weight', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'font-weight');\n    self.changeInput('.rmp-submenu-text-alignment', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'text-align');\n    self.changeInput('#rmp-submenu-text-letter-spacing', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'letter-spacing');\n    self.onTyping('#rmp-submenu-border-width', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'border-width');\n    self.bindColor('#rmp-submenu-item-border-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'border-color');\n    self.bindColor('#rmp-submenu-item-border-colour-hover', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'border-color', 'hover');\n    self.bindColor('#rmp-submenu-item-border-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-current-item .rmp-menu-item-link', 'border-color');\n    self.bindColor('#rmp-submenu-current-item-border-hover-colour', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-current-item .rmp-menu-item-link', 'border-color', 'hover');\n    self.bindColor('#rmp-submenu-link-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'color');\n    self.bindColor('#rmp-submenu-link-hover-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'color', 'hover');\n    self.bindColor('#rmp-submenu-link-colour-active', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-current-item .rmp-menu-item-link', 'color');\n    self.bindColor('#rmp-submenu-link-active-hover-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-current-item .rmp-menu-item-link', 'color', 'hover');\n    self.bindColor('#rmp-submenu-item-background-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'background');\n    self.bindColor('#rmp-submenu-item-background-hover-color', ' #rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-item-link', 'background', 'hover');\n    self.bindColor('#rmp-submenu-current-item-background-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-current-item .rmp-menu-item-link', 'background');\n    self.bindColor('#rmp-submenu-current-item-background-hover-color', '#rmp-menu-wrap-' + self.menuId + ' .rmp-submenu .rmp-menu-current-item .rmp-menu-item-link', 'background', 'hover');\n\n    //Menu Trigger\n    self.changeInput('.rmp-menu-button-transparent-background', '#rmp_menu_trigger-' + self.menuId, 'background', '');\n    self.changeInput('#rmp-menu-button-position-type', '#rmp_menu_trigger-' + self.menuId, 'position');\n    self.changeInput('.rmp-menu-button-left-or-right', '#rmp_menu_trigger-' + self.menuId, 'trigger-side');\n    self.onTyping('#rmp-menu-button-distance-from-side', '#rmp_menu_trigger-' + self.menuId, 'trigger-side-position');\n    self.onTyping('#rmp-menu-button-top', '#rmp_menu_trigger-' + self.menuId, 'top');\n    self.changeInput('#rmp-menu-button-click-animation', '#rmp_menu_trigger-' + self.menuId, 'trigger-animation');\n    self.changeInput('#rmp-menu-button-font', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-label', 'font-family');\n    self.changeInput('.rmp-menu-button-title-position', '#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-label', 'position-alignment');\n    jQuery(\"#rmp-menu-button-font-icon\").focus(function () {\n      var outputSelector = '#rmp_menu_trigger-' + self.menuId + ' span.rmp-trigger-icon-inactive';\n      let value = jQuery(this).val();\n      var iframe = jQuery(self.iframe);\n      if (\"\" != value) {\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box img.rmp-trigger-icon').hide();\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .responsive-menu-pro-inner').hide();\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .rmp-trigger-icon-inactive').remove();\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box').append('<span class=\"rmp-trigger-icon rmp-trigger-icon-inactive\">' + value + '</span>');\n      }\n    });\n    jQuery(\"#rmp-menu-button-font-icon-when-clicked\").focus(function () {\n      var outputSelector = '#rmp_menu_trigger-' + self.menuId + ' span.rmp-trigger-icon-active';\n      let value = jQuery(this).val();\n      var iframe = jQuery(self.iframe);\n      if (\"\" != value) {\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box img.rmp-trigger-icon').hide();\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .responsive-menu-pro-inner').hide();\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box .rmp-trigger-icon-active').remove();\n        iframe.contents().find('#rmp_menu_trigger-' + self.menuId + ' .rmp-trigger-box').append('<span class=\"rmp-trigger-icon rmp-trigger-icon-active\">' + value + '</span>');\n      }\n    });\n\n    // Ordering elements\n    self.toggleElements('#rmp-item-order-title', '#rmp-menu-title-' + self.menuId);\n    self.toggleElements('#rmp-item-order-additional-content', '#rmp-menu-additional-content-' + self.menuId);\n    self.toggleElements('#rmp-item-order-search', '#rmp-search-box-' + self.menuId);\n    self.toggleElements('#rmp-item-order-menu', '#rmp-menu-wrap-' + self.menuId);\n    jQuery('#rmp-menu-ordering-items').sortable({\n      update: function (event, ui) {\n        self.orderMenuElements();\n      }\n    });\n  }\n};\nRMP_Preview.init();\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/js/rmp-preview.js?")},"./assets/admin/js/wp-color-alpha.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**!\n * wp-color-picker-alpha\n *\n * Overwrite Automattic Iris for enabled Alpha Channel in wpColorPicker\n * Only run in input and is defined data alpha in true\n *\n * Version: 2.1.4\n * https://github.com/kallookoo/wp-color-picker-alpha\n * Licensed under the GPLv2 license or later.\n */\n(function ($) {\n  // Prevent double-init.\n  if ($.wp.wpColorPicker.prototype._hasAlpha) {\n    return;\n  }\n\n  // Variable for some backgrounds ( grid )\n  var image = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAAHnlligAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAHJJREFUeNpi+P///4EDBxiAGMgCCCAGFB5AADGCRBgYDh48CCRZIJS9vT2QBAggFBkmBiSAogxFBiCAoHogAKIKAlBUYTELAiAmEtABEECk20G6BOmuIl0CIMBQ/IEMkO0myiSSraaaBhZcbkUOs0HuBwDplz5uFJ3Z4gAAAABJRU5ErkJggg==',\n    //Dtml stuff for wpColorPicker copy of the original color-picker.js\n    _after = '<div class=\"wp-picker-holder\" />',\n    _wrap = '<div class=\"wp-picker-container\" />',\n    _before = '<button type=\"button\" class=\"button wp-color-result\" aria-expanded=\"false\"></button>',\n    _wrappingLabel = '<label></label>',\n    _wrappingLabelText = '<span class=\"screen-reader-text\"></span>';\n\n  /**\n   * Overwrite Color\n   * for enable support rbga\n   */\n  Color.fn.toString = function () {\n    if (this._alpha < 1) return this.toCSS('rgba', this._alpha).replace(/\\s+/g, '');\n    var hex = parseInt(this._color, 10).toString(16);\n    if (this.error) return '';\n    if (hex.length < 6) hex = ('00000' + hex).substr(-6);\n    return '#' + hex;\n  };\n\n  /**\n   * Overwrite wpColorPicker\n   */\n  $.widget('wp.wpColorPicker', $.wp.wpColorPicker, {\n    _hasAlpha: true,\n    /**\n     * @summary Creates the color picker.\n     *\n     * Creates the color picker, sets default values, css classes and wraps it all in HTML.\n     *\n     * @since 3.5.0\n     *\n     * @access private\n     *\n     * @returns {void}\n     */\n    _create: function () {\n      // Return early if Iris support is missing.\n      if (!$.support.iris) {\n        return;\n      }\n      var self = this,\n        el = self.element;\n\n      // Override default options with options bound to the element.\n      $.extend(self.options, el.data());\n\n      // Create a color picker which only allows adjustments to the hue.\n      if (self.options.type === 'hue') {\n        return self._createHueOnly();\n      }\n\n      // Bind the close event.\n      self.close = $.proxy(self.close, self);\n      self.initialValue = el.val();\n\n      // Add a CSS class to the input field.\n      el.addClass('wp-color-picker');\n\n      /*\n      \t* Check if there's already a wrapping label, e.g. in the Customizer.\n      \t* If there's no label, add a default one to match the Customizer template.\n      \t*/\n      if (!el.parent('label').length) {\n        // Wrap the input field in the default label.\n        el.wrap(_wrappingLabel);\n        // Insert the default label text.\n        self.wrappingLabelText = $(_wrappingLabelText).insertBefore(el).text('Color Picker');\n      }\n\n      /*\n      \t* At this point, either it's the standalone version or the Customizer\n      \t* one, we have a wrapping label to use as hook in the DOM, let's store it.\n      \t*/\n      self.wrappingLabel = el.parent();\n\n      // Wrap the label in the main wrapper.\n      self.wrappingLabel.wrap(_wrap);\n      // Store a reference to the main wrapper.\n      self.wrap = self.wrappingLabel.parent();\n      // Set up the toggle button and insert it before the wrapping label.\n      self.toggler = $(_before).insertBefore(self.wrappingLabel).css({\n        backgroundColor: self.initialValue\n      });\n      // Set up the Iris container and insert it after the wrapping label.\n      self.pickerContainer = $(_after).insertAfter(self.wrappingLabel);\n\n      // Wrap the wrapping label in its wrapper and append the Clear/Default button.\n      self.wrappingLabel.wrap('<span class=\"wp-picker-input-wrap hidden rmp-color-input-wrap\" />');\n\n      /*\n      * The input wrapper now contains the label+input+Clear/Default button.\n      * Store a reference to the input wrapper: we'll use this to toggle\n      * the controls visibility.\n      */\n      self.inputWrapper = el.closest('.wp-picker-input-wrap');\n      el.iris({\n        target: self.pickerContainer,\n        hide: self.options.hide,\n        width: 240,\n        mode: self.options.mode,\n        palettes: self.options.palettes,\n        /**\n         * @summary Handles the onChange event if one has been defined in the options.\n         *\n         * Handles the onChange event if one has been defined in the options and additionally\n         * sets the background color for the toggler element.\n         *\n         * @since 3.5.0\n         *\n         * @param {Event} event    The event that's being called.\n         * @param {HTMLElement} ui The HTMLElement containing the color picker.\n         *\n         * @returns {void}\n         */\n        change: function (event, ui) {\n          if (self.options.alpha) {\n            self.toggler.css({\n              'background-image': 'url(' + image + ')'\n            });\n            self.toggler.css({\n              'position': 'relative'\n            });\n            if (self.toggler.find('span.color-alpha').length == 0) {\n              self.toggler.append('<span class=\"color-alpha\" />');\n            }\n            self.toggler.find('span.color-alpha').css({\n              'width': '38px',\n              'height': '100%',\n              'position': 'absolute',\n              'top': 0,\n              'left': 0,\n              'background': ui.color.toString()\n            });\n          } else {\n            self.toggler.css({\n              backgroundColor: ui.color.toString()\n            });\n          }\n          if ($.isFunction(self.options.change)) {\n            self.options.change.call(this, event, ui);\n          }\n        }\n      });\n      el.val(self.initialValue);\n      self._addListeners();\n\n      // Force the color picker to always be closed on initial load.\n      if (!self.options.hide) {\n        self.toggler.click();\n      }\n    },\n    /**\n     * @summary Binds event listeners to the color picker.\n     *\n     * @since 3.5.0\n     *\n     * @access private\n     *\n     * @returns {void}\n     */\n    _addListeners: function () {\n      var self = this;\n\n      /**\n       * @summary Prevent any clicks inside this widget from leaking to the top and closing it.\n       *\n       * @since 3.5.0\n       *\n       * @param {Event} event The event that's being called.\n       *\n       * @returs {void}\n       */\n      self.wrap.on('click.wpcolorpicker', function (event) {\n        event.stopPropagation();\n      });\n\n      /**\n       * @summary Open or close the color picker depending on the class.\n       *\n       * @since 3.5\n       */\n      self.toggler.click(function () {\n        if (self.toggler.hasClass('wp-picker-open')) {\n          self.close();\n        } else {\n          self.open();\n        }\n      });\n\n      /**\n       * @summary Checks if value is empty when changing the color in the color picker.\n       *\n       * Checks if value is empty when changing the color in the color picker.\n       * If so, the background color is cleared.\n       *\n       * @since 3.5.0\n       *\n       * @param {Event} event The event that's being called.\n       *\n       * @returns {void}\n       */\n      self.element.on('change', function (event) {\n        // Empty or Error = clear\n        if ($(this).val() === '' || self.element.hasClass('iris-error')) {\n          if (self.options.alpha) {\n            self.toggler.find('span.color-alpha').css('backgroundColor', '');\n          } else {\n            self.toggler.css('backgroundColor', '');\n          }\n\n          // fire clear callback if we have one\n          if ($.isFunction(self.options.clear)) self.options.clear.call(this, event);\n        }\n      });\n    }\n  });\n\n  /**\n   * Overwrite iris\n   */\n  $.widget('a8c.iris', $.a8c.iris, {\n    _create: function () {\n      this._super();\n\n      // Global option for check is mode rbga is enabled\n      this.options.alpha = this.element.data('alpha') || false;\n\n      // Is not input disabled\n      if (!this.element.is(':input')) this.options.alpha = false;\n      if (typeof this.options.alpha !== 'undefined' && this.options.alpha) {\n        var self = this,\n          el = self.element,\n          _html = '<div class=\"iris-strip iris-slider iris-alpha-slider\"><div class=\"iris-slider-offset iris-slider-offset-alpha\"></div></div>',\n          aContainer = $(_html).appendTo(self.picker.find('.iris-picker-inner')),\n          aSlider = aContainer.find('.iris-slider-offset-alpha'),\n          controls = {\n            aContainer: aContainer,\n            aSlider: aSlider\n          };\n        if (typeof el.data('custom-width') !== 'undefined') {\n          self.options.customWidth = parseInt(el.data('custom-width')) || 0;\n        } else {\n          self.options.customWidth = 100;\n        }\n\n        // Set default width for input reset\n        self.options.defaultWidth = el.width();\n\n        // Update width for input\n        if (self._color._alpha < 1 || self._color.toString().indexOf('rgb') != -1) el.width(parseInt(self.options.defaultWidth + self.options.customWidth));\n\n        // Push new controls\n        $.each(controls, function (k, v) {\n          self.controls[k] = v;\n        });\n\n        // Change size strip and add margin for sliders\n        self.controls.square.css({\n          'margin-right': '0'\n        });\n        var emptyWidth = self.picker.width() - self.controls.square.width() - 20,\n          stripsMargin = emptyWidth / 6,\n          stripsWidth = emptyWidth / 2 - stripsMargin;\n        $.each(['aContainer', 'strip'], function (k, v) {\n          self.controls[v].width(stripsWidth).css({\n            'margin-left': stripsMargin + 'px'\n          });\n        });\n\n        // Add new slider\n        self._initControls();\n\n        // For updated widget\n        self._change();\n      }\n    },\n    _initControls: function () {\n      this._super();\n      if (this.options.alpha) {\n        var self = this,\n          controls = self.controls;\n        controls.aSlider.slider({\n          orientation: 'vertical',\n          min: 0,\n          max: 100,\n          step: 1,\n          value: parseInt(self._color._alpha * 100),\n          slide: function (event, ui) {\n            // Update alpha value\n            self._color._alpha = parseFloat(ui.value / 100);\n            self._change.apply(self, arguments);\n          }\n        });\n      }\n    },\n    _change: function () {\n      this._super();\n      var self = this,\n        el = self.element;\n      if (this.options.alpha) {\n        var controls = self.controls,\n          alpha = parseInt(self._color._alpha * 100),\n          color = self._color.toRgb(),\n          gradient = ['rgb(' + color.r + ',' + color.g + ',' + color.b + ') 0%', 'rgba(' + color.r + ',' + color.g + ',' + color.b + ', 0) 100%'],\n          defaultWidth = self.options.defaultWidth,\n          customWidth = self.options.customWidth,\n          target = self.picker.closest('.wp-picker-container').find('.wp-color-result');\n\n        // Generate background slider alpha, only for CSS3 old browser fuck!! :)\n        controls.aContainer.css({\n          'background': 'linear-gradient(to bottom, ' + gradient.join(', ') + '), url(' + image + ')'\n        });\n        if (target.hasClass('wp-picker-open')) {\n          // Update alpha value\n          controls.aSlider.slider('value', alpha);\n\n          /**\n           * Disabled change opacity in default slider Saturation ( only is alpha enabled )\n           * and change input width for view all value\n           */\n          // if ( self._color._alpha < 1 ) {\n          // \tcontrols.strip.attr( 'style', controls.strip.attr( 'style' ).replace( /rgba\\(([0-9]+,)(\\s+)?([0-9]+,)(\\s+)?([0-9]+)(,(\\s+)?[0-9\\.]+)\\)/g, 'rgb($1$3$5)' ) );\n          // \tel.width( parseInt( defaultWidth + customWidth ) );\n          // } else {\n          // \tel.width( defaultWidth );\n          // }\n        }\n      }\n      var reset = el.data('reset-alpha') || false;\n      if (reset) {\n        self.picker.find('.iris-palette-container').on('click.palette', '.iris-palette', function () {\n          self._color._alpha = 1;\n          self.active = 'external';\n          self._change();\n        });\n      }\n      el.trigger('change');\n    },\n    _addInputListeners: function (input) {\n      var self = this,\n        debounceTimeout = 100,\n        callback = function (event) {\n          var color = new Color(input.val()),\n            val = input.val();\n          input.removeClass('iris-error');\n          // we gave a bad color\n          if (color.error) {\n            // don't error on an empty input\n            if (val !== '') input.addClass('iris-error');\n          } else {\n            if (color.toString() !== self._color.toString()) {\n              // let's not do this on keyup for hex shortcodes\n              if (!(event.type === 'keyup' && val.match(/^[0-9a-fA-F]{3}$/))) self._setOption('color', color.toString());\n            }\n          }\n        };\n      input.on('change', callback).on('keyup', self._debounce(callback, debounceTimeout));\n\n      // If we initialized hidden, show on first focus. The rest is up to you.\n      if (self.options.hide) {\n        input.on('focus', function () {\n          self.show();\n        });\n      }\n    }\n  });\n})(jQuery);\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/js/wp-color-alpha.js?")},"./assets/admin/rmp-main.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _scss_wizard_ui_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scss/wizard-ui.scss */ "./assets/admin/scss/wizard-ui.scss");\n/* harmony import */ var _scss_dark_mode_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scss/dark-mode.scss */ "./assets/admin/scss/dark-mode.scss");\n/* harmony import */ var _js_rmp_admin_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./js/rmp-admin.js */ "./assets/admin/js/rmp-admin.js");\n/* harmony import */ var _js_wp_color_alpha_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./js/wp-color-alpha.js */ "./assets/admin/js/wp-color-alpha.js");\n/* harmony import */ var _js_rmp_editor_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./js/rmp-editor.js */ "./assets/admin/js/rmp-editor.js");\n/* harmony import */ var _js_rmp_icon_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./js/rmp-icon.js */ "./assets/admin/js/rmp-icon.js");\n/* harmony import */ var _js_rmp_preview_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./js/rmp-preview.js */ "./assets/admin/js/rmp-preview.js");\n/* harmony import */ var _js_rmp_menu_wizard_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./js/rmp-menu-wizard.js */ "./assets/admin/js/rmp-menu-wizard.js");\n/**\n * Main scripts file.\n *\n * @package responsive-menu\n */\n\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack://responsive-menu-pro/./assets/admin/rmp-main.js?')}},__webpack_module_cache__={};function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var r=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e](r,r.exports,__webpack_require__),r.exports}__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./assets/admin/rmp-main.js")})();