<?php

if ( ! function_exists( 'qodef_core_import_object' ) ) {
	function qodef_core_import_object() {
		$qodef_core_import_object = new QodefCoreImport();
	}
	
	add_action( 'init', 'qodef_core_import_object' );
}

if ( ! function_exists( 'qodef_core_data_import' ) ) {
	function qodef_core_data_import() {
		$importObject = QodefCoreImport::getInstance();
		
		if ( $_POST['import_attachments'] == 1 ) {
			$importObject->attachments = true;
		} else {
			$importObject->attachments = false;
		}
		
		$folder = "synergia/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_content( $folder . $_POST['xml'] );
		
		die();
	}
	
	add_action( 'wp_ajax_qodef_core_data_import', 'qodef_core_data_import' );
}

if ( ! function_exists( 'qodef_core_widgets_import' ) ) {
	function qodef_core_widgets_import() {
		$importObject = QodefCoreImport::getInstance();
		
		$folder = "synergia/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_widgets( $folder . 'widgets.txt', $folder . 'custom_sidebars.txt' );
		
		die();
	}
	
	add_action( 'wp_ajax_qodef_core_widgets_import', 'qodef_core_widgets_import' );
}

if ( ! function_exists( 'qodef_core_options_import' ) ) {
	function qodef_core_options_import() {
		$importObject = QodefCoreImport::getInstance();
		
		$folder = "synergia/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_options( $folder . 'options.txt' );
		
		die();
	}
	
	add_action( 'wp_ajax_qodef_core_options_import', 'qodef_core_options_import' );
}

if ( ! function_exists( 'qodef_core_other_import' ) ) {
	function qodef_core_other_import() {
		$importObject = QodefCoreImport::getInstance();
		
		$folder = "synergia/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_options( $folder . 'options.txt' );
		$importObject->import_widgets( $folder . 'widgets.txt', $folder . 'custom_sidebars.txt' );
		$importObject->import_menus( $folder . 'menus.txt' );
		$importObject->import_settings_pages( $folder . 'settingpages.txt' );

		$importObject->qodef_update_meta_fields_after_import($folder);
		$importObject->qodef_update_options_after_import($folder);

		if ( qodef_core_is_revolution_slider_installed() ) {
			$importObject->rev_slider_import( $folder );
		}
		
		die();
	}
	
	add_action( 'wp_ajax_qodef_core_other_import', 'qodef_core_other_import' );
}